// Copyright (c) 2022 Giorgos Vougioukas
//
// The license can be found in the LICENSE file.

#ifndef _RHEA_MAIN_WND_H_
#define _RHEA_MAIN_WND_H_

#include "rhea/definitions.h"
#include "rhea/track_wnd.h"

#include "WDL/wingui/wndsize.h"
#include "WDL/wingui/virtwnd.h"
#include "WDL/wingui/virtwnd-controls.h"
#include "WDL/lineparse.h"
#include "WDL/mutex.h"
#include "WDL/aggarray.h"
#include "WDL/ptrlist.h"

class RHEA_MainWnd
{
public:
  RHEA_MainWnd();
  ~RHEA_MainWnd();

  HWND Handle() const { return m_hwnd; }

  void Select(bool deck, int index);
  void SelectNone();

  void ToggleActivate();
  void Eject();

  void Rewind();
  void FastForward();
  void StopRewind();
  void StopFastForward();
  void AltRewind();
  void AltFastForward();
  void GotoStart();
  void GotoEnd();

  void ToggleReverse();
  void Repeat(bool infinite);
  void ClearRepeat();

  void GetSelectedTrack(bool *act, bool *deck, int *index);

  void Search();

  static WDL_DLGRET MainWndProc(HWND hwnd, UINT msg, WPARAM wparam, LPARAM lparam);
private:
  void LoadMedia(bool deck, int index);
  void OnInitDialog(WPARAM wparam, LPARAM lparam);
  void OnSysCommand(WPARAM wparam, LPARAM lparam);
  INT_PTR OnClose(WPARAM wparam, LPARAM lparam);
  void OnSize(WPARAM wparam, LPARAM lparam);
  void OnMove(WPARAM wparam, LPARAM lparam);
  void OnDestroy(WPARAM wparam, LPARAM lparam);
  void OnCommand(WPARAM wparam, LPARAM lparam);
  void OnTimer(WPARAM wparam, LPARAM lparam);
  void OnPaint(WPARAM wparam, LPARAM lparam);
  INT_PTR OnNotify(WPARAM wparam, LPARAM lparam);
  void OnContextMenu(WPARAM wparam, LPARAM lparam);
  void OnLButtonDown(WPARAM wparam, LPARAM lparam);
  void OnLButtonUp(WPARAM wparam, LPARAM lparam);
  void OnMouseMove(WPARAM wparam, LPARAM lparam);
  void OnActivateApp(WPARAM wparam, LPARAM lparam);
  void OnNCLButtonDown(WPARAM wparam, LPARAM lparam);
  WDL_DLGRET MainWndLoop(UINT msg, WPARAM wparam, LPARAM lparam);

  HWND m_hwnd;

  int m_x, m_y, m_w, m_h;
  WDL_WndSizer m_resize;
  HMENU m_main_menu;
  WDL_VirtualWnd_Painter m_painter;

  WDL_PtrList<RHEA_TrackWnd> m_deckwnds;
  WDL_PtrList<RHEA_TrackWnd> m_samplerwnds;

  struct SelectedTrack
  {
    SelectedTrack()
      : act(false)
      , deck(true)
      , idx(0)
    {}

    bool act;
    bool deck;
    int idx;
  };

  SelectedTrack m_sel;
  bool m_scandb;
  WDL_FastString m_titleorig;
};

#endif // _RHEA_MAIN_WND_H_
