// Copyright (c) 2023 Giorgos Vougioukas
//
// The license can be found in the LICENSE file.

#include "rhea/mixer.h"
#include "rhea/buffer_queue.h"

#include "WDL/fpcmp.h"

RHEA_Mixer::RHEA_Mixer()
  : m_output(NULL)
  , m_frames(0)
  , m_nch(0)
{}

RHEA_Mixer::~RHEA_Mixer()
{}

void RHEA_Mixer::Setup(WDL_TypedBuf<SAM> *output, int frames, int nch)
{
  WDL_ASSERT(nch == 2 || nch == 4 || nch == 8);
  m_output = output;
  m_frames = frames;
  m_nch = nch;
}

void RHEA_Mixer::DeckToOutput(RHEA_Track *trk, int index)
{
  int written = 0;
  BQ_Block *blk = NULL;

  switch (m_nch)
  {
  case 2:
    {
      while (written < m_frames)
      {
        if (trk->IsActive() && trk->m_bq.GetBlock(&blk))
        {
          if (blk->samq.Available() / trk->GetChannels() * m_nch > m_frames - written)
          {
            int sz = m_frames - written;

            if (WDL_likely(trk->GetChannels() >= 2))
            {
              for (int i = 0; i < sz; i += m_nch)
              {
                for (int j = 0; j < 2; j++)
                {
                  m_output->Get()[written + i + j] += blk->samq.Get()[j];
                }

                blk->samq.Advance(trk->GetChannels());
              }
            }
            else
            {
              for (int i = 0; i < sz; i += m_nch)
              {
                for (int j = 0; j < 2; j++)
                {
                  m_output->Get()[written + i + j] += blk->samq.Get()[0];
                }

                blk->samq.Advance(trk->GetChannels());
              }
            }

            written += sz;

            blk->samq.Compact();
            if (blk->samq.Available()) trk->m_bq.ReturnBlock(blk);
            else trk->m_bq.DisposeBlock(blk);
          }
          else
          {
            int sz = blk->samq.GetSize() / trk->GetChannels() * m_nch;

            if (WDL_likely(trk->GetChannels() >= 2))
            {
              for (int i = 0; i < sz; i += m_nch)
              {
                for (int j = 0; j < 2; j++)
                {
                  m_output->Get()[written + i + j] += blk->samq.Get()[j];
                }

                blk->samq.Advance(trk->GetChannels());
              }
            }
            else
            {
              for (int i = 0; i < sz; i += m_nch)
              {
                for (int j = 0; j < 2; j++)
                {
                  m_output->Get()[written + i + j] += blk->samq.Get()[0];
                }

                blk->samq.Advance(trk->GetChannels());
              }
            }

            written += sz;

            blk->samq.Clear();
            trk->m_bq.DisposeBlock(blk);
          }
        }
        else
        {
          break;
        }
      }
    } break;
  case 4:
    {
      switch (index)
      {
      case 0:
      case 1:
        {
          while (written < m_frames)
          {
            if (trk->IsActive() && trk->m_bq.GetBlock(&blk))
            {
              if (blk->samq.Available() / trk->GetChannels() * m_nch > m_frames - written)
              {
                int sz = m_frames - written;

                if (WDL_likely(trk->GetChannels() >= 2))
                {
                  for (int i = 0; i < sz; i += m_nch)
                  {
                    for (int j = 0; j < 2; j++)
                    {
                      m_output->Get()[written + i + j] += blk->samq.Get()[j];
                    }

                    blk->samq.Advance(trk->GetChannels());
                  }
                }
                else
                {
                  for (int i = 0; i < sz; i += m_nch)
                  {
                    for (int j = 0; j < 2; j++)
                    {
                      m_output->Get()[written + i + j] += blk->samq.Get()[0];
                    }

                    blk->samq.Advance(trk->GetChannels());
                  }
                }

                written += sz;

                blk->samq.Compact();
                if (blk->samq.Available()) trk->m_bq.ReturnBlock(blk);
                else trk->m_bq.DisposeBlock(blk);
              }
              else
              {
                int sz = blk->samq.GetSize() / trk->GetChannels() * m_nch;

                if (WDL_likely(trk->GetChannels() >= 2))
                {
                  for (int i = 0; i < sz; i += m_nch)
                  {
                    for (int j = 0; j < 2; j++)
                    {
                      m_output->Get()[written + i + j] += blk->samq.Get()[j];
                    }

                    blk->samq.Advance(trk->GetChannels());
                  }
                }
                else
                {
                  for (int i = 0; i < sz; i += m_nch)
                  {
                    for (int j = 0; j < 2; j++)
                    {
                      m_output->Get()[written + i + j] += blk->samq.Get()[0];
                    }

                    blk->samq.Advance(trk->GetChannels());
                  }
                }

                written += sz;

                blk->samq.Clear();
                trk->m_bq.DisposeBlock(blk);
              }
            }
            else
            {
              break;
            }
          }
        }
        break;
      case 2:
      case 3:
        {
          while (written < m_frames)
          {
            if (trk->IsActive() && trk->m_bq.GetBlock(&blk))
            {
              if (blk->samq.Available() / trk->GetChannels() * m_nch > m_frames - written)
              {
                int sz = m_frames - written;

                if (WDL_likely(trk->GetChannels() >= 2))
                {
                  for (int i = 2; i < sz; i += m_nch)
                  {
                    for (int j = 0; j < 2; j++)
                    {
                      m_output->Get()[written + i + j] += blk->samq.Get()[j];
                    }

                    blk->samq.Advance(trk->GetChannels());
                  }
                }
                else
                {
                  for (int i = 2; i < sz; i += m_nch)
                  {
                    for (int j = 0; j < 2; j++)
                    {
                      m_output->Get()[written + i + j] += blk->samq.Get()[0];
                    }

                    blk->samq.Advance(trk->GetChannels());
                  }
                }

                written += sz;

                blk->samq.Compact();
                if (blk->samq.Available()) trk->m_bq.ReturnBlock(blk);
                else trk->m_bq.DisposeBlock(blk);
              }
              else
              {
                int sz = blk->samq.GetSize() / trk->GetChannels() * m_nch;

                if (WDL_likely(trk->GetChannels() >= 2))
                {
                  for (int i = 2; i < sz; i += m_nch)
                  {
                    for (int j = 0; j < 2; j++)
                    {
                      m_output->Get()[written + i + j] += blk->samq.Get()[j];
                    }

                    blk->samq.Advance(trk->GetChannels());
                  }
                }
                else
                {
                  for (int i = 2; i < sz; i += m_nch)
                  {
                    for (int j = 0; j < 2; j++)
                    {
                      m_output->Get()[written + i + j] += blk->samq.Get()[0];
                    }

                    blk->samq.Advance(trk->GetChannels());
                  }
                }

                written += sz;

                blk->samq.Clear();
                trk->m_bq.DisposeBlock(blk);
              }
            }
            else
            {
              break;
            }
          }
        }
        break;
      }
    } break;
  case 8:
    {
      switch (index)
      {
      case 0:
        {
          while (written < m_frames)
          {
            if (trk->IsActive() && trk->m_bq.GetBlock(&blk))
            {
              if (blk->samq.Available() / trk->GetChannels() * m_nch > m_frames - written)
              {
                int sz = m_frames - written;

                if (WDL_likely(trk->GetChannels() >= 2))
                {
                  for (int i = 0; i < sz; i += m_nch)
                  {
                    for (int j = 0; j < 2; j++)
                    {
                      m_output->Get()[written + i + j] += blk->samq.Get()[j];
                    }

                    blk->samq.Advance(trk->GetChannels());
                  }
                }
                else
                {
                  for (int i = 0; i < sz; i += m_nch)
                  {
                    for (int j = 0; j < 2; j++)
                    {
                      m_output->Get()[written + i + j] += blk->samq.Get()[0];
                    }

                    blk->samq.Advance(trk->GetChannels());
                  }
                }

                written += sz;

                blk->samq.Compact();
                if (blk->samq.Available()) trk->m_bq.ReturnBlock(blk);
                else trk->m_bq.DisposeBlock(blk);
              }
              else
              {
                int sz = blk->samq.GetSize() / trk->GetChannels() * m_nch;

                if (WDL_likely(trk->GetChannels() >= 2))
                {
                  for (int i = 0; i < sz; i += m_nch)
                  {
                    for (int j = 0; j < 2; j++)
                    {
                      m_output->Get()[written + i + j] += blk->samq.Get()[j];
                    }

                    blk->samq.Advance(trk->GetChannels());
                  }
                }
                else
                {
                  for (int i = 0; i < sz; i += m_nch)
                  {
                    for (int j = 0; j < 2; j++)
                    {
                      m_output->Get()[written + i + j] += blk->samq.Get()[0];
                    }

                    blk->samq.Advance(trk->GetChannels());
                  }
                }

                written += sz;

                blk->samq.Clear();
                trk->m_bq.DisposeBlock(blk);
              }
            }
            else
            {
              break;
            }
          }
        }
        break;
      case 1:
        {
          while (written < m_frames)
          {
            if (trk->IsActive() && trk->m_bq.GetBlock(&blk))
            {
              if (blk->samq.Available() / trk->GetChannels() * m_nch > m_frames - written)
              {
                int sz = m_frames - written;

                if (WDL_likely(trk->GetChannels() >= 2))
                {
                  for (int i = 2; i < sz; i += m_nch)
                  {
                    for (int j = 0; j < 2; j++)
                    {
                      m_output->Get()[written + i + j] += blk->samq.Get()[j];
                    }

                    blk->samq.Advance(trk->GetChannels());
                  }
                }
                else
                {
                  for (int i = 2; i < sz; i += m_nch)
                  {
                    for (int j = 0; j < 2; j++)
                    {
                      m_output->Get()[written + i + j] += blk->samq.Get()[0];
                    }

                    blk->samq.Advance(trk->GetChannels());
                  }
                }

                written += sz;

                blk->samq.Compact();
                if (blk->samq.Available()) trk->m_bq.ReturnBlock(blk);
                else trk->m_bq.DisposeBlock(blk);
              }
              else
              {
                int sz = blk->samq.GetSize() / trk->GetChannels() * m_nch;

                if (WDL_likely(trk->GetChannels() >= 2))
                {
                  for (int i = 2; i < sz; i += m_nch)
                  {
                    for (int j = 0; j < 2; j++)
                    {
                      m_output->Get()[written + i + j] += blk->samq.Get()[j];
                    }

                    blk->samq.Advance(trk->GetChannels());
                  }
                }
                else
                {
                  for (int i = 2; i < sz; i += m_nch)
                  {
                    for (int j = 0; j < 2; j++)
                    {
                      m_output->Get()[written + i + j] += blk->samq.Get()[0];
                    }

                    blk->samq.Advance(trk->GetChannels());
                  }
                }

                written += sz;

                blk->samq.Clear();
                trk->m_bq.DisposeBlock(blk);
              }
            }
            else
            {
              break;
            }
          }
        }
        break;
      case 2:
        {
          while (written < m_frames)
          {
            if (trk->IsActive() && trk->m_bq.GetBlock(&blk))
            {
              if (blk->samq.Available() / trk->GetChannels() * m_nch > m_frames - written)
              {
                int sz = m_frames - written;

                if (WDL_likely(trk->GetChannels() >= 2))
                {
                  for (int i = 4; i < sz; i += m_nch)
                  {
                    for (int j = 0; j < 2; j++)
                    {
                      m_output->Get()[written + i + j] += blk->samq.Get()[j];
                    }

                    blk->samq.Advance(trk->GetChannels());
                  }
                }
                else
                {
                  for (int i = 4; i < sz; i += m_nch)
                  {
                    for (int j = 0; j < 2; j++)
                    {
                      m_output->Get()[written + i + j] += blk->samq.Get()[0];
                    }

                    blk->samq.Advance(trk->GetChannels());
                  }
                }

                written += sz;

                blk->samq.Compact();
                if (blk->samq.Available()) trk->m_bq.ReturnBlock(blk);
                else trk->m_bq.DisposeBlock(blk);
              }
              else
              {
                int sz = blk->samq.GetSize() / trk->GetChannels() * m_nch;

                if (WDL_likely(trk->GetChannels() >= 2))
                {
                  for (int i = 4; i < sz; i += m_nch)
                  {
                    for (int j = 0; j < 2; j++)
                    {
                      m_output->Get()[written + i + j] += blk->samq.Get()[j];
                    }

                    blk->samq.Advance(trk->GetChannels());
                  }
                }
                else
                {
                  for (int i = 4; i < sz; i += m_nch)
                  {
                    for (int j = 0; j < 2; j++)
                    {
                      m_output->Get()[written + i + j] += blk->samq.Get()[0];
                    }

                    blk->samq.Advance(trk->GetChannels());
                  }
                }

                written += sz;

                blk->samq.Clear();
                trk->m_bq.DisposeBlock(blk);
              }
            }
            else
            {
              break;
            }
          }
        }
        break;
      case 3:
        {
          while (written < m_frames)
          {
            if (trk->IsActive() && trk->m_bq.GetBlock(&blk))
            {
              if (blk->samq.Available() / trk->GetChannels() * m_nch > m_frames - written)
              {
                int sz = m_frames - written;

                if (WDL_likely(trk->GetChannels() >= 2))
                {
                  for (int i = 6; i < sz; i += m_nch)
                  {
                    for (int j = 0; j < 2; j++)
                    {
                      m_output->Get()[written + i + j] += blk->samq.Get()[j];
                    }

                    blk->samq.Advance(trk->GetChannels());
                  }
                }
                else
                {
                  for (int i = 6; i < sz; i += m_nch)
                  {
                    for (int j = 0; j < 2; j++)
                    {
                      m_output->Get()[written + i + j] += blk->samq.Get()[0];
                    }

                    blk->samq.Advance(trk->GetChannels());
                  }
                }

                written += sz;

                blk->samq.Compact();
                if (blk->samq.Available()) trk->m_bq.ReturnBlock(blk);
                else trk->m_bq.DisposeBlock(blk);
              }
              else
              {
                int sz = blk->samq.GetSize() / trk->GetChannels() * m_nch;

                if (WDL_likely(trk->GetChannels() >= 2))
                {
                  for (int i = 6; i < sz; i += m_nch)
                  {
                    for (int j = 0; j < 2; j++)
                    {
                      m_output->Get()[written + i + j] += blk->samq.Get()[j];
                    }

                    blk->samq.Advance(trk->GetChannels());
                  }
                }
                else
                {
                  for (int i = 6; i < sz; i += m_nch)
                  {
                    for (int j = 0; j < 2; j++)
                    {
                      m_output->Get()[written + i + j] += blk->samq.Get()[0];
                    }

                    blk->samq.Advance(trk->GetChannels());
                  }
                }

                written += sz;

                blk->samq.Clear();
                trk->m_bq.DisposeBlock(blk);
              }
            }
            else
            {
              break;
            }
          }
        }
        break;
      }
    } break;
  }
}

void RHEA_Mixer::SamplerToOutput(RHEA_Track *trk, int index)
{
  int written = 0;
  BQ_Block *blk = NULL;

  while (written < m_frames)
  {
    if (trk->IsActive() && trk->m_bq.GetBlock(&blk))
    {
      if (blk->samq.Available() / trk->GetChannels() * m_nch > m_frames - written)
      {
        int sz = m_frames - written;

        if (WDL_likely(trk->GetChannels() >= 2))
        {
          for (int i = 0; i < sz; i += m_nch)
          {
            for (int j = 0; j < m_nch; j += 2)
            {
              m_output->Get()[written + i + j] += blk->samq.Get()[0];
              m_output->Get()[written + i + j + 1] += blk->samq.Get()[1];
            }

            blk->samq.Advance(trk->GetChannels());
          }
        }
        else
        {
          for (int i = 0; i < sz; i += m_nch)
          {
            for (int j = 0; j < m_nch; j += 2)
            {
              m_output->Get()[written + i + j] += blk->samq.Get()[0];
              m_output->Get()[written + i + j + 1] += blk->samq.Get()[0];
            }

            blk->samq.Advance(trk->GetChannels());
          }
        }

        written += sz;

        blk->samq.Compact();
        if (blk->samq.Available()) trk->m_bq.ReturnBlock(blk);
        else trk->m_bq.DisposeBlock(blk);
      }
      else
      {
        int sz = blk->samq.GetSize() / trk->GetChannels() * m_nch;

        if (WDL_likely(trk->GetChannels() >= 2))
        {
          for (int i = 0; i < sz; i += m_nch)
          {
            for (int j = 0; j < m_nch; j += 2)
            {
              m_output->Get()[written + i + j] += blk->samq.Get()[0];
              m_output->Get()[written + i + j + 1] += blk->samq.Get()[1];
            }

            blk->samq.Advance(trk->GetChannels());
          }
        }
        else
        {
          for (int i = 0; i < sz; i += m_nch)
          {
            for (int j = 0; j < m_nch; j += 2)
            {
              m_output->Get()[written + i + j] += blk->samq.Get()[0];
              m_output->Get()[written + i + j + 1] += blk->samq.Get()[0];
            }

            blk->samq.Advance(trk->GetChannels());
          }
        }

        written += sz;

        blk->samq.Clear();
        trk->m_bq.DisposeBlock(blk);
      }
    }
    else
    {
      break;
    }
  }
}

void RHEA_Mixer::DeckTime(RHEA_Track *trk, int index)
{
  BQ_Block *blk = NULL;
  double curtime, tottime;
  int curmin, cursec, curms, totmin, totsec;

  if (trk->m_bq.GetBlock(&blk))
  {
    if (WDL_DefinitelyGreaterThan(blk->time, 0.1) && !trk->IsDrained())
    {
      curtime = blk->time;
      tottime = trk->GetLength();
      curmin = (int)curtime / 60;
      cursec = (int)curtime % 60;
      curms = (int)((curtime - (int)curtime) * 1000);
      totmin = (int)tottime / 60;
      totsec = (int)tottime % 60;
      m_time.SetFormatted(64, "%01d:%02d.%03d / %01d:%02d",
        curmin, cursec, curms, totmin, totsec);
      trk->SetTime(m_time.Get(), curtime);
      trk->m_bq.ReturnBlock(blk);
    }
    else if (WDL_DefinitelyGreaterThan(blk->time, 0.1) && trk->IsDrained())
    {
      curtime = trk->GetLength();
      tottime = trk->GetLength();
      curmin = (int)curtime / 60;
      cursec = (int)curtime % 60;
      curms = (int)((curtime - (int)curtime) * 1000);
      totmin = (int)tottime / 60;
      totsec = (int)tottime % 60;
      m_time.SetFormatted(64, "%01d:%02d.%03d / %01d:%02d",
        curmin, cursec, curms, totmin, totsec);
      trk->SetTime(m_time.Get(), curtime);
      trk->m_bq.ReturnBlock(blk);
    }
    else
    {
      tottime = trk->GetLength();
      totmin = (int)tottime / 60;
      totsec = (int)tottime % 60;
      m_time.SetFormatted(64, "00:00.000 / %01d:%02d", totmin, totsec);
      trk->SetTime(m_time.Get(), 0.0);
      trk->m_bq.ReturnBlock(blk);
    }
  }
  else
  {
    //curtime = trk->GetLength();
    //tottime = trk->GetLength();
    //curmin = (int)curtime / 60;
    //cursec = (int)curtime % 60;
    //curms = (int)((curtime - (int)curtime) * 1000);
    //totmin = (int)tottime / 60;
    //totsec = (int)tottime % 60;
    //m_time.SetFormatted(64, "%01d:%02d.%03d / %01d:%02d",
    //  curmin, cursec, curms, totmin, totsec);
  }
}

void RHEA_Mixer::SamplerTime(RHEA_Track *trk, int index)
{
  BQ_Block *blk = NULL;
  double curtime, tottime;
  int curmin, cursec, curms, totmin, totsec;

  if (trk->m_bq.GetBlock(&blk))
  {
    if (WDL_DefinitelyGreaterThan(blk->time, 0.1) && !trk->IsDrained())
    {
      curtime = blk->time;
      tottime = trk->GetLength();
      curmin = (int)curtime / 60;
      cursec = (int)curtime % 60;
      curms = (int)((curtime - (int)curtime) * 1000);
      totmin = (int)tottime / 60;
      totsec = (int)tottime % 60;
      m_time.SetFormatted(64, "%01d:%02d.%03d / %01d:%02d",
        curmin, cursec, curms, totmin, totsec);
      trk->SetTime(m_time.Get(), curtime);
      trk->m_bq.ReturnBlock(blk);
    }
    else if (WDL_DefinitelyGreaterThan(blk->time, 0.1) && trk->IsDrained())
    {
      curtime = trk->GetLength();
      tottime = trk->GetLength();
      curmin = (int)curtime / 60;
      cursec = (int)curtime % 60;
      curms = (int)((curtime - (int)curtime) * 1000);
      totmin = (int)tottime / 60;
      totsec = (int)tottime % 60;
      m_time.SetFormatted(64, "%01d:%02d.%03d / %01d:%02d",
        curmin, cursec, curms, totmin, totsec);
      trk->SetTime(m_time.Get(), curtime);
      trk->m_bq.ReturnBlock(blk);
    }
    else
    {
      tottime = trk->GetLength();
      totmin = (int)tottime / 60;
      totsec = (int)tottime % 60;
      m_time.SetFormatted(64, "00:00.000 / %01d:%02d", totmin, totsec);
      trk->SetTime(m_time.Get(), 0.0);
      trk->m_bq.ReturnBlock(blk);
    }
  }
  else
  {
    //curtime = trk->GetLength();
    //tottime = trk->GetLength();
    //curmin = (int)curtime / 60;
    //cursec = (int)curtime % 60;
    //curms = (int)((curtime - (int)curtime) * 1000);
    //totmin = (int)tottime / 60;
    //totsec = (int)tottime % 60;
    //m_time.SetFormatted(64, "%01d:%02d.%03d / %01d:%02d",
    //  curmin, cursec, curms, totmin, totsec);
  }
}
