// Copyright (c) 2023 Giorgos Vougioukas
//
// The license can be found in the LICENSE file.

#ifndef _RHEA_MIXER_H_
#define _RHEA_MIXER_H_

#include "rhea/track.h"

#include "WDL/heapbuf.h"
#include "WDL/wdlstring.h"

class RHEA_Mixer
{
public:
  RHEA_Mixer();
  ~RHEA_Mixer();

  void Setup(WDL_TypedBuf<SAM> *output, int frames, int nch);
  void DeckToOutput(RHEA_Track *trk, int index);
  void SamplerToOutput(RHEA_Track *trk, int index);
  void DeckTime(RHEA_Track *trk, int index);
  void SamplerTime(RHEA_Track *trk, int index);

private:
  WDL_TypedBuf<SAM> *m_output;
  int m_frames;
  int m_nch;
  WDL_FastString m_time;
};

#endif // _RHEA_MIXER_H_
