// Copyright (c) 2021 Giorgos Vougioukas
//
// The license can be found in the LICENSE file.

#include "rhea/definitions.h"
#include "rhea/about_wnd.h"
#include "rhea/changelog_wnd.h"
#include "rhea/license_wnd.h"
#include "rhea/main_wnd.h"
#include "rhea/preferences_wnd.h"
#include "rhea/preferences.h"
#include "rhea/waveform_wnd.h"
#include "rhea/search_wnd.h"

// VK_OEM_1: semicolon (0xBA)
// VK_OEM_2: slash (0xBF)
// VK_OEM_3: tilde (0xC0)
// VK_OEM_4: left bracket (0xDB)
// VK_OEM_5: backslash (0xDC)
// VK_OEM_6: right bracket (0xDD)
// VK_OEM_7: quote (0xDE)
// VK_OEM_PLUS: equal (0xBB)
// VK_OEM_MINUS: dash (0xBD)
// VK_OEM_COMMA: comma (0xBC)
// VK_OEM_PERIOD: period (0xBE)

int RHEA_ProcessMessage(MSG *msg)
{
  if (g_searchwnd && (msg->hwnd == g_searchwnd->Handle() || IsChild(g_searchwnd->Handle(), msg->hwnd)))
  {
    if (GetFocus() == GetDlgItem(g_searchwnd->Handle(), IDC_EDIT1))
    {
      if (msg->message == WM_KEYDOWN || msg->message == WM_SYSKEYDOWN /* || msg->message == WM_CHAR */)
      {
        if (msg->lParam & FVIRTKEY)
        {
          if (msg->wParam == VK_RETURN)
          {
            if (!(GetAsyncKeyState(VK_CONTROL) & 0x8000) &&
              !(GetAsyncKeyState(VK_SHIFT) & 0x8000) &&
              !(GetAsyncKeyState(VK_MENU) & 0x8000))
            {
              if (!GetCapture())
              {
                g_searchwnd->Search();
              }

              return 1;
            }
          }
        } // FVIRTKEY

        if (msg->wParam == 'D')
        {
          if (!(GetAsyncKeyState(VK_CONTROL) & 0x8000) &&
            !(GetAsyncKeyState(VK_SHIFT) & 0x8000) &&
            (GetAsyncKeyState(VK_MENU) & 0x8000))
          {
            if (!GetCapture())
            {
              HWND edt = GetDlgItem(g_searchwnd->Handle(), IDC_EDIT1);
              SendMessage(edt, EM_SETSEL, 0, -1);
              SetFocus(edt);
            }

            return 1;
          }
        }
      }
    }
    if (GetFocus() == GetDlgItem(g_searchwnd->Handle(), IDC_LIST1))
    {
      if (msg->message == WM_KEYDOWN || msg->message == WM_SYSKEYDOWN /* || msg->message == WM_CHAR */)
      {
        if (msg->lParam & FVIRTKEY)
        {
          if (msg->wParam == VK_F1)
          {
            if (!(GetAsyncKeyState(VK_CONTROL) & 0x8000) &&
              (GetAsyncKeyState(VK_SHIFT) & 0x8000) &&
              !(GetAsyncKeyState(VK_MENU) & 0x8000))
            {
              if (!GetCapture())
              {
                SendMessage(g_searchwnd->Handle(), WM_COMMAND, ID_SEARCH_LOADTRACKTODECK1, 0);
              }

              return 1;
            }
          }
          if (msg->wParam == VK_F2)
          {
            if (!(GetAsyncKeyState(VK_CONTROL) & 0x8000) &&
              (GetAsyncKeyState(VK_SHIFT) & 0x8000) &&
              !(GetAsyncKeyState(VK_MENU) & 0x8000))
            {
              if (!GetCapture())
              {
                SendMessage(g_searchwnd->Handle(), WM_COMMAND, ID_SEARCH_LOADTRACKTODECK2, 0);
              }

              return 1;
            }
          }
          if (msg->wParam == VK_F3)
          {
            if (!(GetAsyncKeyState(VK_CONTROL) & 0x8000) &&
              (GetAsyncKeyState(VK_SHIFT) & 0x8000) &&
              !(GetAsyncKeyState(VK_MENU) & 0x8000))
            {
              if (!GetCapture())
              {
                SendMessage(g_searchwnd->Handle(), WM_COMMAND, ID_SEARCH_LOADTRACKTODECK3, 0);
              }

              return 1;
            }
          }
          if (msg->wParam == VK_F4)
          {
            if (!(GetAsyncKeyState(VK_CONTROL) & 0x8000) &&
              (GetAsyncKeyState(VK_SHIFT) & 0x8000) &&
              !(GetAsyncKeyState(VK_MENU) & 0x8000))
            {
              if (!GetCapture())
              {
                SendMessage(g_searchwnd->Handle(), WM_COMMAND, ID_SEARCH_LOADTRACKTODECK4, 0);
              }

              return 1;
            }
          }
          if (msg->wParam == VK_F5)
          {
            if (!(GetAsyncKeyState(VK_CONTROL) & 0x8000) &&
              (GetAsyncKeyState(VK_SHIFT) & 0x8000) &&
              !(GetAsyncKeyState(VK_MENU) & 0x8000))
            {
              if (!GetCapture())
              {
                SendMessage(g_searchwnd->Handle(), WM_COMMAND, ID_SEARCH_LOADTRACKTOSAMPLER1, 0);
              }

              return 1;
            }
          }
          if (msg->wParam == VK_F6)
          {
            if (!(GetAsyncKeyState(VK_CONTROL) & 0x8000) &&
              (GetAsyncKeyState(VK_SHIFT) & 0x8000) &&
              !(GetAsyncKeyState(VK_MENU) & 0x8000))
            {
              if (!GetCapture())
              {
                SendMessage(g_searchwnd->Handle(), WM_COMMAND, ID_SEARCH_LOADTRACKTOSAMPLER2, 0);
              }

              return 1;
            }
          }
          if (msg->wParam == VK_F7)
          {
            if (!(GetAsyncKeyState(VK_CONTROL) & 0x8000) &&
              (GetAsyncKeyState(VK_SHIFT) & 0x8000) &&
              !(GetAsyncKeyState(VK_MENU) & 0x8000))
            {
              if (!GetCapture())
              {
                SendMessage(g_searchwnd->Handle(), WM_COMMAND, ID_SEARCH_LOADTRACKTOSAMPLER3, 0);
              }

              return 1;
            }
          }
          if (msg->wParam == VK_F8)
          {
            if (!(GetAsyncKeyState(VK_CONTROL) & 0x8000) &&
              (GetAsyncKeyState(VK_SHIFT) & 0x8000) &&
              !(GetAsyncKeyState(VK_MENU) & 0x8000))
            {
              if (!GetCapture())
              {
                SendMessage(g_searchwnd->Handle(), WM_COMMAND, ID_SEARCH_LOADTRACKTOSAMPLER4, 0);
              }

              return 1;
            }
          }
          if (msg->wParam == VK_F9)
          {
            if (!(GetAsyncKeyState(VK_CONTROL) & 0x8000) &&
              (GetAsyncKeyState(VK_SHIFT) & 0x8000) &&
              !(GetAsyncKeyState(VK_MENU) & 0x8000))
            {
              if (!GetCapture())
              {
                SendMessage(g_searchwnd->Handle(), WM_COMMAND, ID_SEARCH_LOADTRACKTOSAMPLER5, 0);
              }

              return 1;
            }
          }
          if (msg->wParam == VK_F10)
          {
            if (!(GetAsyncKeyState(VK_CONTROL) & 0x8000) &&
              (GetAsyncKeyState(VK_SHIFT) & 0x8000) &&
              !(GetAsyncKeyState(VK_MENU) & 0x8000))
            {
              if (!GetCapture())
              {
                SendMessage(g_searchwnd->Handle(), WM_COMMAND, ID_SEARCH_LOADTRACKTOSAMPLER6, 0);
              }

              return 1;
            }
          }
          if (msg->wParam == VK_F11)
          {
            if (!(GetAsyncKeyState(VK_CONTROL) & 0x8000) &&
              (GetAsyncKeyState(VK_SHIFT) & 0x8000) &&
              !(GetAsyncKeyState(VK_MENU) & 0x8000))
            {
              if (!GetCapture())
              {
                SendMessage(g_searchwnd->Handle(), WM_COMMAND, ID_SEARCH_LOADTRACKTOSAMPLER7, 0);
              }

              return 1;
            }
          }
          if (msg->wParam == VK_F12)
          {
            if (!(GetAsyncKeyState(VK_CONTROL) & 0x8000) &&
              (GetAsyncKeyState(VK_SHIFT) & 0x8000) &&
              !(GetAsyncKeyState(VK_MENU) & 0x8000))
            {
              if (!GetCapture())
              {
                SendMessage(g_searchwnd->Handle(), WM_COMMAND, ID_SEARCH_LOADTRACKTOSAMPLER8, 0);
              }

              return 1;
            }
          }
        } // FVIRTKEY

        if (msg->wParam == 'D')
        {
          if (!(GetAsyncKeyState(VK_CONTROL) & 0x8000) &&
            !(GetAsyncKeyState(VK_SHIFT) & 0x8000) &&
            (GetAsyncKeyState(VK_MENU) & 0x8000))
          {
            if (!GetCapture())
            {
              HWND edt = GetDlgItem(g_searchwnd->Handle(), IDC_EDIT1);
              SendMessage(edt, EM_SETSEL, 0, -1);
              SetFocus(edt);
            }

            return 1;
          }
        }
      }
    }
  }
  if (g_mainwnd && (msg->hwnd == g_mainwnd->Handle() || IsChild(g_mainwnd->Handle(), msg->hwnd)))
  {
    if (msg->wParam == VK_CONTROL &&
        (msg->message == WM_KEYDOWN ||
          msg->message == WM_KEYUP))
    {
      if (GetCapture() == g_mainwnd->Handle())
      {
        //InvalidateRect(g_mainwnd->Handle(), NULL, FALSE);
      }
    }

    //if (msg->message == WM_MOUSEWHEEL)
    //{
    //  SendMessage(msg->hwnd, WM_MOUSEWHEEL, msg->wParam, msg->lParam);

    //  return 1;
    //}

    if (msg->message == WM_KEYDOWN || msg->message == WM_SYSKEYDOWN /* || msg->message == WM_CHAR */)
    {
      if (msg->lParam & FVIRTKEY)
      {
        if (msg->wParam == VK_F1)
        {
          if ((GetAsyncKeyState(VK_CONTROL) & 0x8000) &&
            !(GetAsyncKeyState(VK_SHIFT) & 0x8000) &&
            !(GetAsyncKeyState(VK_MENU) & 0x8000))
          {
            if (!GetCapture())
            {
              SendMessage(g_mainwnd->Handle(), WM_COMMAND, ID_HELP_ABOUT, 0);
            }

            return 1;
          }
        }
        if (msg->wParam == VK_F2)
        {
          if ((GetAsyncKeyState(VK_CONTROL) & 0x8000) &&
            !(GetAsyncKeyState(VK_SHIFT) & 0x8000) &&
            !(GetAsyncKeyState(VK_MENU) & 0x8000))
          {
            if (!GetCapture())
            {
              SendMessage(g_mainwnd->Handle(), WM_COMMAND, ID_HELP_CHANGELOG, 0);
            }

            return 1;
          }
        }
        if (msg->wParam == VK_F3)
        {
          if ((GetAsyncKeyState(VK_CONTROL) & 0x8000) &&
            !(GetAsyncKeyState(VK_SHIFT) & 0x8000) &&
            !(GetAsyncKeyState(VK_MENU) & 0x8000))
          {
            if (!GetCapture())
            {
              SendMessage(g_mainwnd->Handle(), WM_COMMAND, ID_HELP_VERSION, 0);
            }

            return 1;
          }
        }
        if (msg->wParam == VK_F1)
        {
          if (!(GetAsyncKeyState(VK_CONTROL) & 0x8000) &&
            !(GetAsyncKeyState(VK_SHIFT) & 0x8000) &&
            !(GetAsyncKeyState(VK_MENU) & 0x8000))
          {
            if (!GetCapture())
            {
              g_mainwnd->Select(true, 0);
            }

            return 1;
          }
        }
        if (msg->wParam == VK_F2)
        {
          if (!(GetAsyncKeyState(VK_CONTROL) & 0x8000) &&
            !(GetAsyncKeyState(VK_SHIFT) & 0x8000) &&
            !(GetAsyncKeyState(VK_MENU) & 0x8000))
          {
            if (!GetCapture())
            {
              g_mainwnd->Select(true, 1);
            }

            return 1;
          }
        }
        if (msg->wParam == VK_F3)
        {
          if (!(GetAsyncKeyState(VK_CONTROL) & 0x8000) &&
            !(GetAsyncKeyState(VK_SHIFT) & 0x8000) &&
            !(GetAsyncKeyState(VK_MENU) & 0x8000))
          {
            if (!GetCapture())
            {
              g_mainwnd->Select(true, 2);
            }

            return 1;
          }
        }
        if (msg->wParam == VK_F4)
        {
          if (!(GetAsyncKeyState(VK_CONTROL) & 0x8000) &&
            !(GetAsyncKeyState(VK_SHIFT) & 0x8000) &&
            !(GetAsyncKeyState(VK_MENU) & 0x8000))
          {
            if (!GetCapture())
            {
              g_mainwnd->Select(true, 3);
            }

            return 1;
          }
        }
        if (msg->wParam == VK_F5)
        {
          if (!(GetAsyncKeyState(VK_CONTROL) & 0x8000) &&
            !(GetAsyncKeyState(VK_SHIFT) & 0x8000) &&
            !(GetAsyncKeyState(VK_MENU) & 0x8000))
          {
            if (!GetCapture())
            {
              g_mainwnd->Select(false, 0);
            }

            return 1;
          }
        }
        if (msg->wParam == VK_F6)
        {
          if (!(GetAsyncKeyState(VK_CONTROL) & 0x8000) &&
            !(GetAsyncKeyState(VK_SHIFT) & 0x8000) &&
            !(GetAsyncKeyState(VK_MENU) & 0x8000))
          {
            if (!GetCapture())
            {
              g_mainwnd->Select(false, 1);
            }

            return 1;
          }
        }
        if (msg->wParam == VK_F7)
        {
          if (!(GetAsyncKeyState(VK_CONTROL) & 0x8000) &&
            !(GetAsyncKeyState(VK_SHIFT) & 0x8000) &&
            !(GetAsyncKeyState(VK_MENU) & 0x8000))
          {
            if (!GetCapture())
            {
              g_mainwnd->Select(false, 2);
            }

            return 1;
          }
        }
        if (msg->wParam == VK_F8)
        {
          if (!(GetAsyncKeyState(VK_CONTROL) & 0x8000) &&
            !(GetAsyncKeyState(VK_SHIFT) & 0x8000) &&
            !(GetAsyncKeyState(VK_MENU) & 0x8000))
          {
            if (!GetCapture())
            {
              g_mainwnd->Select(false, 3);
            }

            return 1;
          }
        }
        if (msg->wParam == VK_F9)
        {
          if (!(GetAsyncKeyState(VK_CONTROL) & 0x8000) &&
            !(GetAsyncKeyState(VK_SHIFT) & 0x8000) &&
            !(GetAsyncKeyState(VK_MENU) & 0x8000))
          {
            if (!GetCapture())
            {
              g_mainwnd->Select(false, 4);
            }

            return 1;
          }
        }
        if (msg->wParam == VK_F10)
        {
          if (!(GetAsyncKeyState(VK_CONTROL) & 0x8000) &&
            !(GetAsyncKeyState(VK_SHIFT) & 0x8000) &&
            !(GetAsyncKeyState(VK_MENU) & 0x8000))
          {
            if (!GetCapture())
            {
              g_mainwnd->Select(false, 5);
            }

            return 1;
          }
        }
        if (msg->wParam == VK_F11)
        {
          if (!(GetAsyncKeyState(VK_CONTROL) & 0x8000) &&
            !(GetAsyncKeyState(VK_SHIFT) & 0x8000) &&
            !(GetAsyncKeyState(VK_MENU) & 0x8000))
          {
            if (!GetCapture())
            {
              g_mainwnd->Select(false, 6);
            }

            return 1;
          }
        }
        if (msg->wParam == VK_F12)
        {
          if (!(GetAsyncKeyState(VK_CONTROL) & 0x8000) &&
            !(GetAsyncKeyState(VK_SHIFT) & 0x8000) &&
            !(GetAsyncKeyState(VK_MENU) & 0x8000))
          {
            if (!GetCapture())
            {
              g_mainwnd->Select(false, 7);
            }

            return 1;
          }
        }
        if (msg->wParam == VK_ESCAPE)
        {
          if (!(GetAsyncKeyState(VK_CONTROL) & 0x8000) &&
            !(GetAsyncKeyState(VK_SHIFT) & 0x8000) &&
            !(GetAsyncKeyState(VK_MENU) & 0x8000))
          {
            if (!GetCapture())
            {
              g_mainwnd->SelectNone();
            }

            return 1;
          }
        }
        if (msg->wParam == VK_DELETE)
        {
          if (!(GetAsyncKeyState(VK_CONTROL) & 0x8000) &&
            !(GetAsyncKeyState(VK_SHIFT) & 0x8000) &&
            !(GetAsyncKeyState(VK_MENU) & 0x8000))
          {
            if (!GetCapture())
            {
              g_mainwnd->Eject();
            }

            return 1;
          }
        }
        if (msg->wParam == VK_F1)
        {
          if (!(GetAsyncKeyState(VK_CONTROL) & 0x8000) &&
            (GetAsyncKeyState(VK_SHIFT) & 0x8000) &&
            !(GetAsyncKeyState(VK_MENU) & 0x8000))
          {
            if (!GetCapture())
            {
              SendMessage(g_mainwnd->Handle(), WM_COMMAND, ID_FILE_LOADTRACKTODECK1, 0);
            }

            return 1;
          }
        }
        if (msg->wParam == VK_F2)
        {
          if (!(GetAsyncKeyState(VK_CONTROL) & 0x8000) &&
            (GetAsyncKeyState(VK_SHIFT) & 0x8000) &&
            !(GetAsyncKeyState(VK_MENU) & 0x8000))
          {
            if (!GetCapture())
            {
              SendMessage(g_mainwnd->Handle(), WM_COMMAND, ID_FILE_LOADTRACKTODECK2, 0);
            }

            return 1;
          }
        }
        if (msg->wParam == VK_F3)
        {
          if (!(GetAsyncKeyState(VK_CONTROL) & 0x8000) &&
            (GetAsyncKeyState(VK_SHIFT) & 0x8000) &&
            !(GetAsyncKeyState(VK_MENU) & 0x8000))
          {
            if (!GetCapture())
            {
              SendMessage(g_mainwnd->Handle(), WM_COMMAND, ID_FILE_LOADTRACKTODECK3, 0);
            }

            return 1;
          }
        }
        if (msg->wParam == VK_F4)
        {
          if (!(GetAsyncKeyState(VK_CONTROL) & 0x8000) &&
            (GetAsyncKeyState(VK_SHIFT) & 0x8000) &&
            !(GetAsyncKeyState(VK_MENU) & 0x8000))
          {
            if (!GetCapture())
            {
              SendMessage(g_mainwnd->Handle(), WM_COMMAND, ID_FILE_LOADTRACKTODECK4, 0);
            }

            return 1;
          }
        }
        if (msg->wParam == VK_F5)
        {
          if (!(GetAsyncKeyState(VK_CONTROL) & 0x8000) &&
            (GetAsyncKeyState(VK_SHIFT) & 0x8000) &&
            !(GetAsyncKeyState(VK_MENU) & 0x8000))
          {
            if (!GetCapture())
            {
              SendMessage(g_mainwnd->Handle(), WM_COMMAND, ID_FILE_LOADTRACKTOSAMPLER1, 0);
            }

            return 1;
          }
        }
        if (msg->wParam == VK_F6)
        {
          if (!(GetAsyncKeyState(VK_CONTROL) & 0x8000) &&
            (GetAsyncKeyState(VK_SHIFT) & 0x8000) &&
            !(GetAsyncKeyState(VK_MENU) & 0x8000))
          {
            if (!GetCapture())
            {
              SendMessage(g_mainwnd->Handle(), WM_COMMAND, ID_FILE_LOADTRACKTOSAMPLER2, 0);
            }

            return 1;
          }
        }
        if (msg->wParam == VK_F7)
        {
          if (!(GetAsyncKeyState(VK_CONTROL) & 0x8000) &&
            (GetAsyncKeyState(VK_SHIFT) & 0x8000) &&
            !(GetAsyncKeyState(VK_MENU) & 0x8000))
          {
            if (!GetCapture())
            {
              SendMessage(g_mainwnd->Handle(), WM_COMMAND, ID_FILE_LOADTRACKTOSAMPLER3, 0);
            }

            return 1;
          }
        }
        if (msg->wParam == VK_F8)
        {
          if (!(GetAsyncKeyState(VK_CONTROL) & 0x8000) &&
            (GetAsyncKeyState(VK_SHIFT) & 0x8000) &&
            !(GetAsyncKeyState(VK_MENU) & 0x8000))
          {
            if (!GetCapture())
            {
              SendMessage(g_mainwnd->Handle(), WM_COMMAND, ID_FILE_LOADTRACKTOSAMPLER4, 0);
            }

            return 1;
          }
        }
        if (msg->wParam == VK_F9)
        {
          if (!(GetAsyncKeyState(VK_CONTROL) & 0x8000) &&
            (GetAsyncKeyState(VK_SHIFT) & 0x8000) &&
            !(GetAsyncKeyState(VK_MENU) & 0x8000))
          {
            if (!GetCapture())
            {
              SendMessage(g_mainwnd->Handle(), WM_COMMAND, ID_FILE_LOADTRACKTOSAMPLER5, 0);
            }

            return 1;
          }
        }
        if (msg->wParam == VK_F10)
        {
          if (!(GetAsyncKeyState(VK_CONTROL) & 0x8000) &&
            (GetAsyncKeyState(VK_SHIFT) & 0x8000) &&
            !(GetAsyncKeyState(VK_MENU) & 0x8000))
          {
            if (!GetCapture())
            {
              SendMessage(g_mainwnd->Handle(), WM_COMMAND, ID_FILE_LOADTRACKTOSAMPLER6, 0);
            }

            return 1;
          }
        }
        if (msg->wParam == VK_F11)
        {
          if (!(GetAsyncKeyState(VK_CONTROL) & 0x8000) &&
            (GetAsyncKeyState(VK_SHIFT) & 0x8000) &&
            !(GetAsyncKeyState(VK_MENU) & 0x8000))
          {
            if (!GetCapture())
            {
              SendMessage(g_mainwnd->Handle(), WM_COMMAND, ID_FILE_LOADTRACKTOSAMPLER7, 0);
            }

            return 1;
          }
        }
        if (msg->wParam == VK_F12)
        {
          if (!(GetAsyncKeyState(VK_CONTROL) & 0x8000) &&
            (GetAsyncKeyState(VK_SHIFT) & 0x8000) &&
            !(GetAsyncKeyState(VK_MENU) & 0x8000))
          {
            if (!GetCapture())
            {
              SendMessage(g_mainwnd->Handle(), WM_COMMAND, ID_FILE_LOADTRACKTOSAMPLER8, 0);
            }

            return 1;
          }
        }
        if (msg->wParam == VK_HOME)
        {
          if (!(GetAsyncKeyState(VK_CONTROL) & 0x8000) &&
            !(GetAsyncKeyState(VK_SHIFT) & 0x8000) &&
            !(GetAsyncKeyState(VK_MENU) & 0x8000))
          {
            if (!GetCapture())
            {
              SendMessage(g_waveformwnd->Handle(), WM_KEYDOWN, VK_HOME, 0);
            }

            return 1;
          }
        }
        if (msg->wParam == VK_END)
        {
          if (!(GetAsyncKeyState(VK_CONTROL) & 0x8000) &&
            !(GetAsyncKeyState(VK_SHIFT) & 0x8000) &&
            !(GetAsyncKeyState(VK_MENU) & 0x8000))
          {
            if (!GetCapture())
            {
              SendMessage(g_waveformwnd->Handle(), WM_KEYDOWN, VK_END, 0);
            }

            return 1;
          }
        }
        if (msg->wParam == VK_PRIOR)
        {
          if (!(GetAsyncKeyState(VK_CONTROL) & 0x8000) &&
            !(GetAsyncKeyState(VK_SHIFT) & 0x8000) &&
            !(GetAsyncKeyState(VK_MENU) & 0x8000))
          {
            if (!GetCapture())
            {
              SendMessage(g_waveformwnd->Handle(), WM_KEYDOWN, VK_PRIOR, 0);
            }

            return 1;
          }
        }
        if (msg->wParam == VK_NEXT)
        {
          if (!(GetAsyncKeyState(VK_CONTROL) & 0x8000) &&
            !(GetAsyncKeyState(VK_SHIFT) & 0x8000) &&
            !(GetAsyncKeyState(VK_MENU) & 0x8000))
          {
            if (!GetCapture())
            {
              SendMessage(g_waveformwnd->Handle(), WM_KEYDOWN, VK_NEXT, 0);
            }

            return 1;
          }
        }
        if (msg->wParam == VK_UP)
        {
          if (!(GetAsyncKeyState(VK_CONTROL) & 0x8000) &&
            !(GetAsyncKeyState(VK_SHIFT) & 0x8000) &&
            !(GetAsyncKeyState(VK_MENU) & 0x8000))
          {
            if (!GetCapture())
            {
              SendMessage(g_waveformwnd->Handle(), WM_KEYDOWN, VK_UP, 0);
            }

            return 1;
          }
        }
        if (msg->wParam == VK_DOWN)
        {
          if (!(GetAsyncKeyState(VK_CONTROL) & 0x8000) &&
            !(GetAsyncKeyState(VK_SHIFT) & 0x8000) &&
            !(GetAsyncKeyState(VK_MENU) & 0x8000))
          {
            if (!GetCapture())
            {
              SendMessage(g_waveformwnd->Handle(), WM_KEYDOWN, VK_DOWN, 0);
            }

            return 1;
          }
        }
      } // FVIRTKEY

      if (msg->wParam == 'R')
      {
        if ((GetAsyncKeyState(VK_CONTROL) & 0x8000) &&
          (GetAsyncKeyState(VK_SHIFT) & 0x8000) &&
          !(GetAsyncKeyState(VK_MENU) & 0x8000))
        {
          if (!GetCapture())
          {
            g_mainwnd->Repeat(true);
          }

          return 1;
        }
      }
      if (msg->wParam == 'R')
      {
        if (!(GetAsyncKeyState(VK_CONTROL) & 0x8000) &&
          !(GetAsyncKeyState(VK_SHIFT) & 0x8000) &&
          !(GetAsyncKeyState(VK_MENU) & 0x8000))
        {
          if (!GetCapture())
          {
            g_mainwnd->Repeat(false);
          }

          return 1;
        }
      }
      if (msg->wParam == 'R')
      {
        if (!(GetAsyncKeyState(VK_CONTROL) & 0x8000) &&
          (GetAsyncKeyState(VK_SHIFT) & 0x8000) &&
          !(GetAsyncKeyState(VK_MENU) & 0x8000))
        {
          if (!GetCapture())
          {
            g_mainwnd->ClearRepeat();
          }

          return 1;
        }
      }
      if (msg->wParam == 'R')
      {
        if ((GetAsyncKeyState(VK_CONTROL) & 0x8000) &&
          !(GetAsyncKeyState(VK_SHIFT) & 0x8000) &&
          !(GetAsyncKeyState(VK_MENU) & 0x8000))
        {
          if (!GetCapture())
          {
            g_mainwnd->ToggleReverse();
          }

          return 1;
        }
      }
      if (msg->wParam == 'F')
      {
        if ((GetAsyncKeyState(VK_CONTROL) & 0x8000) &&
          !(GetAsyncKeyState(VK_SHIFT) & 0x8000) &&
          !(GetAsyncKeyState(VK_MENU) & 0x8000))
        {
          if (!GetCapture())
          {
            g_mainwnd->Search();
          }

          return 1;
        }
      }
      if (msg->wParam == VK_SPACE)
      {
        if (!(GetAsyncKeyState(VK_CONTROL) & 0x8000) &&
          !(GetAsyncKeyState(VK_SHIFT) & 0x8000) &&
          !(GetAsyncKeyState(VK_MENU) & 0x8000))
        {
          if (!GetCapture())
          {
            g_mainwnd->ToggleActivate();
          }

          return 1;
        }
      }
      if (msg->wParam == 'Z')
      {
        if (!(GetAsyncKeyState(VK_CONTROL) & 0x8000) &&
          !(GetAsyncKeyState(VK_SHIFT) & 0x8000) &&
          !(GetAsyncKeyState(VK_MENU) & 0x8000))
        {
          if (!GetCapture())
          {
            g_mainwnd->Rewind();
          }

          return 1;
        }
      }
      if (msg->wParam == 'X')
      {
        if (!(GetAsyncKeyState(VK_CONTROL) & 0x8000) &&
          !(GetAsyncKeyState(VK_SHIFT) & 0x8000) &&
          !(GetAsyncKeyState(VK_MENU) & 0x8000))
        {
          if (!GetCapture())
          {
            g_mainwnd->FastForward();
          }

          return 1;
        }
      }
      if (msg->wParam == 'Z')
      {
        if (!(GetAsyncKeyState(VK_CONTROL) & 0x8000) &&
          (GetAsyncKeyState(VK_SHIFT) & 0x8000) &&
          !(GetAsyncKeyState(VK_MENU) & 0x8000))
        {
          if (!GetCapture())
          {
            g_mainwnd->AltRewind();
          }

          return 1;
        }
      }
      if (msg->wParam == 'X')
      {
        if (!(GetAsyncKeyState(VK_CONTROL) & 0x8000) &&
          (GetAsyncKeyState(VK_SHIFT) & 0x8000) &&
          !(GetAsyncKeyState(VK_MENU) & 0x8000))
        {
          if (!GetCapture())
          {
            g_mainwnd->AltFastForward();
          }

          return 1;
        }
      }
      if (msg->wParam == 'Z')
      {
        if ((GetAsyncKeyState(VK_CONTROL) & 0x8000) &&
          !(GetAsyncKeyState(VK_SHIFT) & 0x8000) &&
          !(GetAsyncKeyState(VK_MENU) & 0x8000))
        {
          if (!GetCapture())
          {
            g_mainwnd->GotoStart();
          }

          return 1;
        }
      }
      if (msg->wParam == 'X')
      {
        if ((GetAsyncKeyState(VK_CONTROL) & 0x8000) &&
          !(GetAsyncKeyState(VK_SHIFT) & 0x8000) &&
          !(GetAsyncKeyState(VK_MENU) & 0x8000))
        {
          if (!GetCapture())
          {
            g_mainwnd->GotoEnd();
          }

          return 1;
        }
      }
      if (msg->wParam == 'P')
      {
        if ((GetAsyncKeyState(VK_CONTROL) & 0x8000) &&
          !(GetAsyncKeyState(VK_SHIFT) & 0x8000) &&
          !(GetAsyncKeyState(VK_MENU) & 0x8000))
        {
          if (!GetCapture())
          {
            SendMessage(g_mainwnd->Handle(), WM_COMMAND, ID_OPTIONS_PREFERENCES, 0);
          }

          return 1;
        }
      }
      if (msg->wParam == 'Q')
      {
        if ((GetAsyncKeyState(VK_CONTROL) & 0x8000) &&
          !(GetAsyncKeyState(VK_SHIFT) & 0x8000) &&
          !(GetAsyncKeyState(VK_MENU) & 0x8000))
        {
          if (!GetCapture())
          {
            SendMessage(g_mainwnd->Handle(), WM_COMMAND, ID_FILE_EXIT, 0);
          }

          return 1;
        }
      }
    }

    if (msg->message == WM_KEYUP || msg->message == WM_SYSKEYUP /* || msg->message == WM_CHAR */)
    {
      if (msg->wParam == 'Z')
      {
        if (!(GetAsyncKeyState(VK_CONTROL) & 0x8000) &&
          !(GetAsyncKeyState(VK_SHIFT) & 0x8000) &&
          !(GetAsyncKeyState(VK_MENU) & 0x8000))
        {
          if (!GetCapture())
          {
            g_mainwnd->StopRewind();
          }

          return 1;
        }
      }
      if (msg->wParam == 'X')
      {
        if (!(GetAsyncKeyState(VK_CONTROL) & 0x8000) &&
          !(GetAsyncKeyState(VK_SHIFT) & 0x8000) &&
          !(GetAsyncKeyState(VK_MENU) & 0x8000))
        {
          if (!GetCapture())
          {
            g_mainwnd->StopFastForward();
          }

          return 1;
        }
      }
      if (msg->wParam == 'Z')
      {
        if (!(GetAsyncKeyState(VK_CONTROL) & 0x8000) &&
          (GetAsyncKeyState(VK_SHIFT) & 0x8000) &&
          !(GetAsyncKeyState(VK_MENU) & 0x8000))
        {
          if (!GetCapture())
          {
            g_mainwnd->StopRewind();
          }

          return 1;
        }
      }
      if (msg->wParam == 'X')
      {
        if (!(GetAsyncKeyState(VK_CONTROL) & 0x8000) &&
          (GetAsyncKeyState(VK_SHIFT) & 0x8000) &&
          !(GetAsyncKeyState(VK_MENU) & 0x8000))
        {
          if (!GetCapture())
          {
            g_mainwnd->StopFastForward();
          }

          return 1;
        }
      }
    }
  }

  return 0;
}

void RHEA_RunMessageLoop()
{
#if defined(_WIN32)
  for (;;) // Justin Frankel in the loop
  {
    MSG msg = { 0, };
    int vvv = GetMessage(&msg, NULL, 0, 0);

    if (!vvv)
    {
      break;
    }

    if (vvv < 0)
    {
      Sleep(10);
      continue;
    }

    if (!msg.hwnd)
    {
      DispatchMessage(&msg);
      continue;
    }

    vvv = RHEA_ProcessMessage(&msg);

    if (vvv > 0)
    {
      continue;
    }

    if (g_mainwnd->Handle())
    {
      if (IsDialogMessage(g_mainwnd->Handle(), &msg))
      {
        continue;
      }
    }

    if (g_changelogwnd)
    {
      if (IsDialogMessage(g_changelogwnd->Handle(), &msg))
      {
        continue;
      }
    }

    if (g_prefwnd)
    {
      if (IsDialogMessage(g_prefwnd->Handle(), &msg))
      {
        continue;
      }
    }

    if (g_licwnd)
    {
      if (IsDialogMessage(g_licwnd->Handle(), &msg))
      {
        continue;
      }
    }

    if (g_aboutwnd)
    {
      if (IsDialogMessage(g_aboutwnd->Handle(), &msg))
      {
        continue;
      }
    }

    if (g_searchwnd)
    {
      if (IsDialogMessage(g_searchwnd->Handle(), &msg))
      {
        continue;
      }
    }

    HWND parent = NULL;
    HWND temp = msg.hwnd;

    do
    {
      if (GetClassLong(temp, GCW_ATOM) == (INT)32770)
      {
        parent = temp;

        if (!(GetWindowLong(temp, GWL_STYLE) &WS_CHILD))
        {
          break;  // not a child, exit
        }
      }
    }
    while (temp = GetParent(temp));

    if (parent && IsDialogMessage(parent, &msg))
    {
      continue;
    }

    TranslateMessage(&msg);
    DispatchMessage(&msg);
  }
#else
  for (;;)
  {
    MSG msg = { 0, };
    int x = RHEA_ProcessMessage(&msg);

    if (x == 0)
    {
      break;
    }
  }
#endif
}
