// Copyright (c) 2021 Giorgos Vougioukas
//
// The license can be found in the LICENSE file.

#ifndef _RHEA_MODULE_CREATION_H_
#define _RHEA_MODULE_CREATION_H_

#include "rhea/definitions.h"
#include "rhea/rhea_plugin.h"

RHEA_IFileInput *CreateFileInput(const char *filename);
RHEA_IFileTag *CreateFileTag(const char *filename);
RHEA_IFileTag *CreateEditFileTag(const char *filename);
RHEA_IFilePic *CreateFilePic(const char *filename);
RHEA_IAudioStreamer *CreateAudioStreamer();
RHEA_IAudioStreamerDevice *CreateAudioStreamerDevice(const char *name);
RHEA_IPitchShift *CreatePitchShift(const char *name);
RHEA_IFXProcessor *CreateFXProcessor();

void LoadPlugins();
void ReleasePlugins();

#endif // _RHEA_MODULE_CREATION_H_
