// Copyright (c) 2020 Giorgos Vougioukas
//
// The license can be found in the LICENSE file.

#ifndef _RHEA_QUERY_H_
#define _RHEA_QUERY_H_

#include "rhea/definitions.h"
//#include "rhea/playlist.h"
#include "third_party/sqlite/sqlite3.h"

#include "WDL/assocarray.h"
#include "WDL/wdlstring.h"
#include "WDL/ptrlist.h"
#include "WDL/mutex.h"

struct PlayListEntry
{
  int active;
  WDL_FastString type;
  WDL_FastString title;
  WDL_FastString artist;
  WDL_FastString album;
  double length;
  WDL_FastString genre;
  double srate;
  WDL_FastString filename;
  WDL_FastString filepath;
  WDL_FastString fileext;
  WDL_INT64 filesize;
  WDL_FastString comment;
};

class RHEA_Query
{
public:
  RHEA_Query();
  ~RHEA_Query();

  bool Open();
  bool IsOpen() const;
  void Close();

  bool Query(const char *text);
  const char *QueryText() const;

  WDL_PtrList<PlayListEntry> *GetMatches();

private:
  bool HasRow();
  const char *GetColumnText(int col);
  double GetColumnDouble(int col);
  WDL_INT64 GetColumnInt64(int col);
  void NextStep();

  bool m_open;
  WDL_FastString m_fn;
  sqlite3 *m_db;
  sqlite3_stmt *m_stmt;
  char *m_errmsg;

  WDL_FastString m_strbuf;

  int m_step;
  int m_querylimit;
  WDL_FastString m_querysql;
  WDL_FastString m_querytext;

  WDL_PtrList<PlayListEntry> m_matches;
};

#endif // _RHEA_QUERY_H_
