// Copyright (c) 2021 Giorgos Vougioukas
//
// The plug-in mechanism derived from REAPER plug-in API
// Copyright (c) 2006-2009, Cockos Incorporated
//
// This software is provided 'as-is', without any express or implied
// warranty.  In no event will the authors be held liable for any damages
// arising from the use of this software.
//
// Permission is granted to anyone to use this software for any purpose,
// including commercial applications, and to alter it and redistribute it
// freely, subject to the following restrictions:
//
//  1. The origin of this software must not be misrepresented; you must not
//     claim that you wrote the original software. If you use this software
//     in a product, an acknowledgment in the product documentation would be
//     appreciated but is not required.
//  2. Altered source versions must be plainly marked as such, and must not be
//     misrepresented as being the original software.
//  3. This notice may not be removed or altered from any source distribution.
//
//  Notes: the C++ interfaces used require MSVC on win32, or at least the
//  MSVC-compatible C++ ABI. Sorry, mingw users :(

#ifndef _RHEA_PLUGIN_H_
#define _RHEA_PLUGIN_H_

#include "rhea/rhea_plugin_public.h"

#include "rhea/sample_format.h"
#include "WDL/wdltypes.h"
#include "WDL/assocarray.h"

typedef void (*RHEA_AudioCallback)(WDL_TypedBuf<SAM> *output, int frame_count, int nch);

class RHEA_IAudioStreamer
{
public:
  virtual ~RHEA_IAudioStreamer()
  {}

  virtual bool Open() = 0;
  virtual void Close() = 0;
  virtual void Start(RHEA_AudioCallback callback) = 0;
  virtual void Stop() = 0;
  virtual bool IsRunning() const = 0;
  virtual double GetSampleRate() const = 0;
  virtual int GetChannels() const = 0;
};

struct RHEA_AudioStreamerRegister
{
  RHEA_IAudioStreamer *(*CreateAudioStreamer)();
};

class RHEA_IAudioStreamerDevice
{
public:
  RHEA_IAudioStreamerDevice();
  virtual ~RHEA_IAudioStreamerDevice()
  {}

  virtual void Scan() = 0;

  virtual int GetDefaultInputDevice() const = 0;
  virtual int GetDefaultOutputDevice() const = 0;

  WDL_IntKeyedArray<const char *> input_dev;
  WDL_IntKeyedArray<const char *> output_dev;
};

struct RHEA_AudioStreamerDeviceRegister
{
  RHEA_IAudioStreamerDevice *(*CreateAudioStreamerDevice)();
};

class RHEA_IFXProcessor
{
public:
  virtual ~RHEA_IFXProcessor()
  {}

  virtual void AddSamples(SAM *buffer, int buffer_size) = 0;
  virtual int GetSamples(SAM *buffer, int buffer_size) = 0;
};

struct RHEA_FXProcessorRegister
{
  RHEA_IFXProcessor *(*CreateFXProcessor)();
};

#endif // _RHEA_PLUGIN_H_
