// Copyright (c) 2022 Giorgos Vougioukas
//
// The license can be found in the LICENSE file.

#ifndef _RHEA_TRACK_H_
#define _RHEA_TRACK_H_

#include "rhea/definitions.h"
#include "rhea/buffer_queue.h"
#include "rhea/sample_format.h"
#include "rhea/antidote_input.h"
#include "rhea/plugin.h"

#include "WDL/heapbuf.h"
#include "WDL/wdlstring.h"

class RHEA_Track
{
public:
  RHEA_Track();
  ~RHEA_Track();

  void Load(RHEA_AntidoteInput *ai, bool deck, int index);
  bool IsLoaded() const;
  void Eject(bool clear_peaks);

  void Active(bool active);
  bool IsActive() const;

  bool IsDrained() const;
  bool WantMore() const;
  bool DoBuffering();

  double GetLength() const { return m_length; }
  int GetChannels() const { return m_nch; }

  void SetTime(const char *time, double timesec);
  double GetTimeSec() const;
  const char *GetTime() const;
  const char *GetTitle() const;
  const char *GetArtist() const;

  void SetShift(double shift);
  void SetTempo(double tempo);
  void Reverse(bool state);
  bool IsReverse() const;
  int RepeatCount() const;
  void Repeat(bool infinite);
  void ClearRepeat();

  void Seek(double time);

  RHEA_BufferQueue m_bq;
private:
  WDL_TypedBuf<SAM> m_buffer;

  bool m_eof;
  int m_bqms;

  RHEA_AntidoteInput *m_input;

  double m_length;
  int m_nch;

  WDL_FastString m_time;
  double m_timesec;
  bool m_act;
  RHEA_IPitchShift *m_ps;
  double m_shift;
  double m_tempo;

  bool m_deck;
  int m_idx;
  int m_rpt;
};

#endif // _RHEA_TRACK_H_
