// Copyright (c) 2023 Giorgos Vougioukas
//
// The license can be found in the LICENSE file.

#ifndef _RHEA_WAVEFORM_H_
#define _RHEA_WAVEFORM_H_

#include "rhea/definitions.h"

#include "WDL/mutex.h"
#include "WDL/heapbuf.h"
#include "WDL/wdlstring.h"
#include "WDL/lice/lice.h"
#include "WDL/lice/lice_text.h"

class RHEA_Waveform
{
public:
  RHEA_Waveform();
  ~RHEA_Waveform();

  LICE_IBitmap *GetBitMap(int width, int height);

private:
  void DrawWaveForm(float *pk, size_t sz, int sector,
    int width, double time, double length, bool selected,
    bool reverse, int repeat, const char *label);
  void StartThread();
  void StopThread();
  bool IsRunning() const;
  static unsigned int WINAPI ThreadFunction(void *arg);
  int Run();

  struct ThreadDetails
  {
    unsigned int id;
    HANDLE thread;
  };

  WDL_TypedBuf<ThreadDetails> m_threads;
  bool m_killthread;
  WDL_Mutex m_mutex;
  bool m_running;

  LICE_IBitmap *m_bm;
  WDL_FastString m_strbuf;

  LICE_CachedFont m_label;
  LICE_CachedFont m_repeat;
};

#endif // _RHEA_WAVEFORM_H_
