#include "rhea_flac/flac_tag.h"
#include "rhea_flac/flac_entry_point.h"

#include "WDL/win32_utf8.h"

RHEA_FlacTag::RHEA_FlacTag()
  : m_file(NULL)
  , m_metadata(false, WDL_StringKeyedArray<char *>::freecharptr)
{}

RHEA_FlacTag::~RHEA_FlacTag()
{
  if (m_file) delete m_file;
  m_metadata.DeleteAll();
}

bool RHEA_FlacTag::Open(const char *filename)
{
  bool res = false;
  m_fn.Set(filename);

  int rmode, rbufsize, rnbufs;
  RHEA_GetDiskReadMode(&rmode, &rbufsize, &rnbufs);
  m_file = new WDL_NEW WDL_FileRead(filename, rmode, rbufsize, rnbufs);

  if (!m_file || !m_file->IsOpen())
  {
    return false;
  }

#ifdef _WIN32
  flac_internal_set_utf8_filenames(true);
#endif

  FLAC__Metadata_Chain *chain = FLAC__metadata_chain_new();
  if (FLAC__metadata_chain_read(chain, m_fn.Get()))
  {
    FLAC__Metadata_Iterator *it = FLAC__metadata_iterator_new();
    FLAC__metadata_iterator_init(it, chain);

    WDL_FastString ss;
    while (FLAC__metadata_iterator_next(it))
    {
      FLAC__StreamMetadata *meta = FLAC__metadata_iterator_get_block(it);
      if (meta->type == FLAC__METADATA_TYPE_VORBIS_COMMENT)
      {
        for (int i = 0; i < (int)meta->data.vorbis_comment.num_comments; i++)
        {
          ss.SetRaw((const char *)meta->data.vorbis_comment.comments[i].entry,
            meta->data.vorbis_comment.comments[i].length);

          if (!strnicmp(ss.Get(), "TITLE=", 6))
          {
            ss.DeleteSub(0, 6);
            m_metadata.Insert("TITLE", strdup(ss.Get()));
          }
          else if (!strnicmp(ss.Get(), "ALBUM=", 6))
          {
            ss.DeleteSub(0, 6);
            m_metadata.Insert("ALBUM", strdup(ss.Get()));
          }
          else if (!strnicmp(ss.Get(), "TRACKNUMBER=", 12))
          {
            ss.DeleteSub(0, 12);
            m_metadata.Insert("TRACKNUMBER", strdup(ss.Get()));
          }
          else if (!strnicmp(ss.Get(), "ARTIST=", 7))
          {
            ss.DeleteSub(0, 7);
            m_metadata.Insert("ARTIST", strdup(ss.Get()));
          }
          else if (!strnicmp(ss.Get(), "DESCRIPTION=", 12))
          {
            ss.DeleteSub(0, 12);
            m_metadata.Insert("DESCRIPTION", strdup(ss.Get()));
          }
          else if (!strnicmp(ss.Get(), "GENRE=", 6))
          {
            ss.DeleteSub(0, 6);
            m_metadata.Insert("GENRE", strdup(ss.Get()));
          }
          else if (!strnicmp(ss.Get(), "DATE=", 5))
          {
            ss.DeleteSub(0, 5);
            m_metadata.Insert("DATE", strdup(ss.Get()));
          }
        }
      }
    }
    FLAC__metadata_iterator_delete(it); res = true;
  }

  FLAC__metadata_chain_delete(chain);

  return res;
}

const char *RHEA_FlacTag::GetType() const
{
  return "FLAC";
}

const char *RHEA_FlacTag::GetTitle() const
{
  return m_metadata.Get("TITLE", "");
}

const char *RHEA_FlacTag::GetArtist() const
{
  return m_metadata.Get("ARTIST", "");
}

const char *RHEA_FlacTag::GetAlbum() const
{
  return m_metadata.Get("ALBUM", "");
}

const char *RHEA_FlacTag::GetGenre() const
{
  return m_metadata.Get("GENRE", "");
}

const char *RHEA_FlacTag::GetTrack() const
{
  return m_metadata.Get("TRACKNUMBER", "");
}

const char *RHEA_FlacTag::GetYear() const
{
  return m_metadata.Get("DATE", "");
}

const char *RHEA_FlacTag::GetComment() const
{
  return m_metadata.Get("DESCRIPTION", "");
}

WDL_INT64 RHEA_FlacTag::GetFileSize() const
{
  return m_file->GetSize();
}

const char *RHEA_FlacTag::GetFileName() const
{
  return m_fn.get_filepart();
}

const char *RHEA_FlacTag::GetFilePath() const
{
  return m_fn.Get();
}

const char *RHEA_FlacTag::GetFileExtension() const
{
  return m_fn.get_fileext();
}

void RHEA_FlacTag::SetTitle(const char *val)
{}

void RHEA_FlacTag::SetArtist(const char *val)
{}

void RHEA_FlacTag::SetAlbum(const char *val)
{}

void RHEA_FlacTag::SetGenre(const char *val)
{}

void RHEA_FlacTag::SetTrack(const char *val)
{}

void RHEA_FlacTag::SetYear(const char *val)
{}

void RHEA_FlacTag::SetComment(const char *val)
{}

bool RHEA_FlacTag::Save()
{
  return false;
}
