#ifndef _RHEA_MP3_AUDIO_INPUT_H_
#define _RHEA_MP3_AUDIO_INPUT_H_

#if defined(_WIN32)
#include <windows.h>
#include <windowsx.h>
#include <commctrl.h>
#include <process.h>
#else
#include "WDL/swell/swell.h"
#include "WDL/swell/swell-functions.h"
#endif

#if defined(__linux__)
#define NO_POSIX_FILEREAD
#include <sys/types.h>
#include <unistd.h>
#endif

#include "rhea_mp3/mp3_decoder.h"
#include "rhea_mp3/mp3_index.h"

#include "rhea/sample_format.h"
#include "rhea/rhea_plugin_public.h"

#include "WDL/wdlstring.h"
#include "WDL/fileread.h"
#include "WDL/filewrite.h"
#include "WDL/assocarray.h"
#include "WDL/queue.h"
#include "WDL/resample.h"
#include "WDL/mutex.h"

class RHEA_Mp3Input : public RHEA_IFileInput
{
public:
  RHEA_Mp3Input();
  ~RHEA_Mp3Input();

  bool Open(const char *filename);

  const char *GetType() const;

  const char *GetFileName() const;

  int GetChannels() const;

  double GetSampleRate() const;

  double GetLength() const;

  int GetBitsPerSample() const;

  double GetPosition() const;

  void Seek(double time);

  int GetSamples(SAM *buffer, int length);

  bool IsStreaming() const;

  int Extended(int call, void *parm1, void *parm2, void *parm3);

private:
  bool m_eof;
  RHEA_Mp3Decoder m_decoder;
  RHEA_Mp3Index *m_index;

  WDL_FileRead *m_file;
  WDL_FastString m_fn;

  int m_channelmode;
  int m_channels;
  int m_bitspersample;
  double m_samplerate;
  WDL_INT64 m_lengthsamples;

  WDL_TypedQueue<SAM> m_samples;
  WDL_Resampler m_rs;

  double m_currentpos;

  double m_hwsamplerate;

  unsigned int m_streamstartpos;
  unsigned int m_streamendpos;
  unsigned int m_readpos;
  WDL_StringKeyedArray<char *> m_metadata;
  struct frame m_syncframeinfo;
  WDL_TypedBuf<SAM> m_rbuf;
};

#endif // _RHEA_MP3_AUDIO_INPUT_H_
