#include "rhea_opus/opus_apic.h"
#include "rhea_opus/opus_entry_point.h"

#include "WDL/wdl_base64.h"
#include "WDL/wdlutf8.h"
#include "WDL/metadata.h"

RHEA_OpusAPIC::RHEA_OpusAPIC()
  : m_file(NULL)
  , m_metadata(false, WDL_StringKeyedArray<char *>::freecharptr)
{}

RHEA_OpusAPIC::~RHEA_OpusAPIC()
{
  if (m_file) delete m_file;
}

bool RHEA_OpusAPIC::Open(const char *filename)
{
  WDL_ASSERT(filename != NULL);

  m_fn.Set(filename);

  //int rmode, rbufsize, rnbufs;
  //RHEA_GetDiskReadMode(&rmode, &rbufsize, &rnbufs);
  //m_file = new WDL_NEW WDL_FileRead(filename, rmode, rbufsize, rnbufs);

  //if (!m_file || !m_file->IsOpen())
  //{
  //  return false;
  //}

  return false;
}

int RHEA_OpusAPIC::GetPicSize() const
{
  return m_apic.GetSize();
}

void *RHEA_OpusAPIC::GetPic() const
{
  return m_apic.Get();
}
