// Copyright (c) 2020 Giorgos Vougioukas
//
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU Lesser General Public License as published by
// the Free Software Foundation; either version 2.1 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
// GNU Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public License
// along with this program; if not, write to the Free Software Foundation,
// Inc., 51 Franklin Street, Fifth Floor, Boston MA 02110-1301, USA.

#ifndef _RHEA_TAGLIB_TAGGER_H_
#define _RHEA_TAGLIB_TAGGER_H_

#include "rhea/rhea_plugin_public.h"

#include <taglib.h>
#include <fileref.h>
#include <tag.h>
#include <tbytevector.h>
#include <tpropertymap.h>
#include <flacfile.h>
#include <mpegfile.h>
#include <oggfile.h>
#include <oggflacfile.h>
#include <vorbisfile.h>
#include <id3v2tag.h>
#include <id3v1tag.h>
#include <apetag.h>
#include <xiphcomment.h>

#include "WDL/wdlstring.h"

class RHEA_GenericTag : public RHEA_IFileTag
{
public:
  RHEA_GenericTag();
  ~RHEA_GenericTag();

  bool Open(const char *filename);

  const char *GetType() const;

  const char *GetTitle() const;
  const char *GetArtist() const;
  const char *GetAlbum() const;
  const char *GetGenre() const;
  const char *GetTrack() const;
  const char *GetYear() const;
  const char *GetComment() const;

  void SetTitle(const char *val);
  void SetArtist(const char *val);
  void SetAlbum(const char *val);
  void SetGenre(const char *val);
  void SetTrack(const char *val);
  void SetYear(const char *val);
  void SetComment(const char *val);
  bool Save();

  int GetBitRate() const;
  double GetSampleRate() const;
  int GetChannels() const;
  double GetLength() const;
  WDL_INT64 GetFileSize() const;
  const char *GetFileName() const;
  const char *GetFilePath() const;
  const char *GetFileExtension() const;
  const char *GetSHA() const;

private:
  void ReadID3v2(TagLib::ID3v2::Tag *tag);
  void ReadID3v1(TagLib::ID3v1::Tag *tag);
  void ReadXiphComment(TagLib::Ogg::XiphComment *tag);
  void ReadPlain(TagLib::Tag *tag);

  WDL_FastString m_fn;
  WDL_FastString m_sha;

  WDL_FastString m_title;
  WDL_FastString m_artist;
  WDL_FastString m_album;
  WDL_FastString m_genre;
  WDL_FastString m_track;
  WDL_FastString m_year;
  WDL_FastString m_comment;

  int m_bitrate;
  double m_samplerate;
  int m_channels;
  int m_length;
  WDL_INT64 m_file_size;
};

#endif // _RHEA_TAGLIB_TAGGER_H_
