#ifndef _RHEA_VORBIS_ATTACHED_PICTURE_H_
#define _RHEA_VORBIS_ATTACHED_PICTURE_H_

#include "rhea/rhea_plugin_public.h"

#include <vorbis/vorbisfile.h>

#include "WDL/heapbuf.h"
#include "WDL/fileread.h"
#include "WDL/wdlstring.h"
#include "WDL/assocarray.h"

class RHEA_VorbisAPIC : public RHEA_IFilePic
{
public:
  RHEA_VorbisAPIC();
  ~RHEA_VorbisAPIC();

  bool Open(const char *filename);

  int GetPicSize() const;
  void *GetPic() const;

private:
  WDL_HeapBuf m_apic;
  WDL_FastString m_fn;
  WDL_FileRead *m_file;
  WDL_StringKeyedArray<char *> m_metadata;
  OggVorbis_File m_vf;
  WDL_FastString m_strbuf;
};

#endif // _RHEA_VORBIS_ATTACHED_PICTURE_H_
