rem Retrieve major/minor version
rem ============================

setlocal enabledelayedexpansion

for /f "delims=" %%a in ('findstr /b /c:"#define RHEA_MAJOR_VERSION " ..\..\src\rhea\app_info.h') do (
  set pwd=%%a
  set "pwd=!pwd:Password: =!"
)

set major_ver="%pwd%"
set maj=%major_ver:~28,1%

for /f "delims=" %%a in ('findstr /b /c:"#define RHEA_MINOR_VERSION " ..\..\src\rhea\app_info.h') do (
  set pwd=%%a
  set "pwd=!pwd:Password: =!"
)

set minor_ver="%pwd%"
set min=%minor_ver:~28,2%

for /f "delims=" %%a in ('findstr /b /c:"#define RHEA_RELEASE " ..\..\src\rhea\app_info.h') do (
  set pwd=%%a
  set "pwd=!pwd:Password: =!"
)

set release="%pwd%"
set rel=%release:~23%

rmdir /s /q build
rmdir /s /q src
del /s /q rhea-taglib*.zip

mkdir build
mkdir build\vc
rem mkdir build\linux
mkdir src
mkdir src\WDL-GV
mkdir src\rhea
mkdir src\rhea_taglib
mkdir src\third_party
mkdir src\third_party\taglib

xcopy /y /s ..\..\src\WDL-GV src\WDL-GV
xcopy /y ..\..\src\rhea\rhea_plugin_public.h src\rhea
xcopy /y ..\..\src\rhea\sample_format.h src\rhea
xcopy /y ..\..\build\vc\rhea-taglib.* build\vc
rem xcopy /y ..\..\build\linux\makefile_rhea_taglib.mk build\linux
rem xcopy /y ..\..\build\linux\Makefile build\linux
xcopy /y /s ..\..\src\rhea_taglib src\rhea_taglib
xcopy /y /s ..\..\src\third_party\taglib src\third_party\taglib

7z a -tzip -mx=1 rhea-taglib-%maj%.%min%%rel%-src.zip build
7z a -tzip -mx=1 rhea-taglib-%maj%.%min%%rel%-src.zip src
7z a -tzip -mx=1 rhea-taglib-%maj%.%min%%rel%-src.zip README.txt
7z d -r rhea-taglib-%maj%.%min%%rel%-src.zip build\vc\Win32
7z d -r rhea-taglib-%maj%.%min%%rel%-src.zip build\vc\x64
7z d -r rhea-taglib-%maj%.%min%%rel%-src.zip *.o
7z t rhea-taglib-%maj%.%min%%rel%-src.zip * -r

rmdir /s /q build
rmdir /s /q src

pause
