// Copyright (c) 2021 Giorgos Vougioukas
//
// The license can be found in the LICENSE file.

#ifndef _RHEA_DEFINITIONS_H_
#define _RHEA_DEFINITIONS_H_

#if defined(_WIN32)
#include <windows.h>
#include <windowsx.h>
#include <commctrl.h>
#include <process.h>
#else
#include "WDL/swell/swell.h"
#include "WDL/swell/swell-functions.h"
#endif

#include "rhea/res/resource.h"
#include "rhea/sample_format.h"

#include "WDL/wdltypes.h"
#include "WDL/win32_utf8.h"
#include "WDL/heapbuf.h"
#include "WDL/ptrlist.h"
#include "WDL/wdlstring.h"
#include "WDL/assocarray.h"

class RHEA_IAudioStreamer;
class RHEA_AboutWnd;
class RHEA_ChangelogWnd;
class RHEA_LicenseWnd;
class RHEA_MainWnd;
class RHEA_PreferencesWnd;
class RHEA_Preferences;
class RHEA_MediaInput;
class RHEA_Track;
class RHEA_Hestia;
class RHEA_Track;
class RHEA_Peaks;
class RHEA_WaveformWnd;
class RHEA_SearchWnd;
class RHEA_Database;
class RHEA_Query;
class LICE_IBitmap;

extern HINSTANCE g_inst;
extern UINT g_scrollmessage;
extern bool g_hasrequestedquit;

extern WDL_FastString g_modpath;
extern WDL_FastString g_setpath;
extern WDL_FastString g_inipath;
extern WDL_FastString g_media_ext;

extern RHEA_IAudioStreamer *g_audiostreamer;
extern RHEA_Preferences *g_preferences;
extern RHEA_MediaInput *g_mediainput;
extern RHEA_Hestia *g_hestia;
extern RHEA_Peaks *g_peaks;
extern RHEA_Database *g_database;
extern RHEA_Query *g_query;

extern RHEA_MainWnd *g_mainwnd;
extern RHEA_LicenseWnd *g_licwnd;
extern RHEA_ChangelogWnd *g_changelogwnd;
extern RHEA_PreferencesWnd *g_prefwnd;
extern RHEA_AboutWnd *g_aboutwnd;
extern RHEA_WaveformWnd *g_waveformwnd;
extern RHEA_SearchWnd *g_searchwnd;

extern LICE_IBitmap *g_scrollbar;

extern WDL_PtrKeyedArray<const char *> g_pluginimport;
extern WDL_StringKeyedArray<void *> g_pluginexport;

extern void RHEA_RunMessageLoop();
extern int RHEA_ProcessMessage(MSG *msg);
extern void RHEA_OnAudioData(WDL_TypedBuf<SAM> *output, int frame_count, int nch);

typedef void (*RHEA_MediaInputDeckCallback)(WDL_PtrList<RHEA_Track> *decks);
extern void RHEA_OnMediaInputDeck(WDL_PtrList<RHEA_Track> *decks);
typedef void (*RHEA_MediaInputSamplerCallback)(WDL_PtrList<RHEA_Track> *samplers);
extern void RHEA_OnMediaInputSampler(WDL_PtrList<RHEA_Track> *samplers);

extern double RHEA_GetAudioDeviceSamplerate();
extern int RHEA_GetAudioDeviceBitDepth();
extern int RHEA_GetAudioDeviceOutputChannels();
extern void RHEA_GetDiskReadMode(int *rmode, int *rbufsize, int *rnbufs);
extern void RHEA_GetDiskWriteMode(int *wmode, int *wbufsize, int *wminbufs, int *wmaxbufs);
extern int RHEA_GetDiskIOPriority();
extern int RHEA_GetDiskIOSleepStep();
extern int RHEA_GetAntidoteBitDepth();
extern int RHEA_GetAudioSystem();
extern void RHEA_GetResampleMode(bool *interp, int *filtercnt,
  bool *sinc, int *sinc_size, int *sinc_interpsize);
extern bool RHEA_GetWASAPIExclusiveMode();

#endif // _RHEA_DEFINITIONS_H_
