// Copyright (c) 2023 Giorgos Vougioukas
//
// The license can be found in the LICENSE file.

#ifndef _RHEA_HESTIA_H_
#define _RHEA_HESTIA_H_

#include "rhea/definitions.h"
#include "rhea/plugin.h"
#include "rhea/track.h"
#include "rhea/mixer.h"

#include "WDL/mutex.h"
#include "WDL/heapbuf.h"
#include "WDL/ptrlist.h"
#include "WDL/wdlstring.h"

class RHEA_Hestia
{
public:
  RHEA_Hestia();
  ~RHEA_Hestia();

  void Start(RHEA_MediaInputDeckCallback dcb,
    RHEA_MediaInputSamplerCallback scb);
  void Stop();

  void AudioData(WDL_TypedBuf<SAM> *output, int frame_count, int nch);

  int DeckCount() const;
  int SamplerCount() const;

  double GetTimeSec(bool deck, int index) const;
  const char *GetTime(bool deck, int index) const;
  const char *GetTitle(bool deck, int index) const;
  const char *GetArtist(bool deck, int index) const;

  void ToggleActivate(bool deck, int index);
  bool IsActive(bool deck, int index) const;
  void Eject(bool deck, int index);

  void Rewind(bool deck, int index);
  void FastForward(bool deck, int index);
  void StopRewind(bool deck, int index);
  void StopFastForward(bool deck, int index);
  void AltRewind(bool deck, int index);
  void AltFastForward(bool deck, int index);
  void GotoStart(bool deck, int index);
  void GotoEnd(bool deck, int index);

  bool IsReverse(bool deck, int index) const;
  void ToggleReverse(bool deck, int index);
  int RepeatCount(bool deck, int index) const;
  void Repeat(bool deck, int index, bool infinite);
  void ClearRepeat(bool deck, int index);

  double GetLength(bool deck, int index) const;

private:
  void StartThread();
  void StopThread();
  bool IsRunning() const;
  static unsigned int WINAPI ThreadFunctionForDecks(void *arg);
  static unsigned int WINAPI ThreadFunctionForSamplers(void *arg);
  int RunDecks();
  int RunSamplers();

  struct ThreadDetails
  {
    unsigned int id;
    HANDLE thread;
  };

  WDL_TypedBuf<ThreadDetails> m_dthreads;
  bool m_dkillthread;
  WDL_Mutex m_dmutex;
  WDL_TypedBuf<ThreadDetails> m_sthreads;
  bool m_skillthread;
  WDL_Mutex m_smutex;
  bool m_running;

  RHEA_MediaInputDeckCallback m_dcb;
  RHEA_MediaInputSamplerCallback m_scb;
  WDL_PtrList<RHEA_Track> m_decks;
  WDL_PtrList<RHEA_Track> m_samplers;
  volatile int m_dwait;
  volatile int m_swait;

  RHEA_Mixer m_mixer;
  bool m_ffrew;

  double m_shift;
  double m_tempo;
  double m_altshift;
  double m_alttempo;
};

#endif // _RHEA_HESTIA_H_
