// Copyright (c) 2023 Giorgos Vougioukas
//
// The license can be found in the LICENSE file.

#ifndef _RHEA_LIBRARY_WND_H_
#define _RHEA_LIBRARY_WND_H_

#include "rhea/definitions.h"

#include "WDL/heapbuf.h"
#include "WDL/wdlstring.h"
#include "WDL/wingui/wndsize.h"

class RHEA_LibraryWnd
{
public:
  RHEA_LibraryWnd();
  ~RHEA_LibraryWnd();

  HWND Handle() const { return m_hwnd; }
  static WDL_DLGRET LibraryWndProc(HWND hwnd, UINT msg, WPARAM wparam, LPARAM lparam);
private:
  void OnInitDialog(WPARAM wparam, LPARAM lparam);
  void OnDestroy(WPARAM wparam, LPARAM lparam);
  void OnSize(WPARAM wparam, LPARAM lparam);
  void OnCommand(WPARAM wparam, LPARAM lparam);
  WDL_DLGRET LibraryWndLoop(UINT msg, WPARAM wparam, LPARAM lparam);

  HWND m_hwnd;
  WDL_WndSizer m_resize;
};

#endif // _RHEA_LIBRARY_WND_H_
