// Copyright (c) 2023 Giorgos Vougioukas
//
// The license can be found in the LICENSE file.

#ifndef _RHEA_PEAKS_H_
#define _RHEA_PEAKS_H_

#include "WDL/ptrlist.h"
#include "WDL/mutex.h"

class RHEA_Peaks
{
public:
  RHEA_Peaks();
  ~RHEA_Peaks();

  void PreAllocate(double time);
  bool Allocate(size_t request, bool deck, int index);
  void AddPeaks(float *peaks, size_t len, bool deck, int index);
  void PeaksReady(bool deck, int index);
  void ClearPeaks(bool deck, int index);
  bool HasPeaks(bool deck, int index) const;

  int DeckCount() const { return m_dpeaks.GetSize(); }
  int SamplerCount() const { return m_speaks.GetSize(); }

  float *GetPeaks(bool deck, int index);
  size_t GetPeaksSize(bool deck, int index) const;
  void DoneWithPeaks() { m_mutex.Leave(); }

private:
  struct PeaksBlock
  {
    PeaksBlock()
      : rdy(false)
      , pk(NULL)
      , sz(0)
      , cp(0)
    {}

    ~PeaksBlock()
    {
      if (pk) free(pk);
    }

    bool rdy;
    float *pk;
    size_t sz;
    size_t cp;
  };

  WDL_PtrList<PeaksBlock> m_dpeaks;
  WDL_PtrList<PeaksBlock> m_speaks;
  WDL_Mutex m_mutex;
};

#endif // _RHEA_PEAKS_H_
