// Copyright (c) 2021 Giorgos Vougioukas
//
// The license can be found in the LICENSE file.

#ifndef _RHEA_PREFERENCES_H_
#define _RHEA_PREFERENCES_H_

#include "third_party/cJSON/cJSON.h"

#include <string.h>
#include <stdlib.h>

#include "WDL/wdlstring.h"
#include "WDL/ptrlist.h"

class RHEA_Preferences
{
public:
  RHEA_Preferences();
  ~RHEA_Preferences();

  void Create();
  void Open(bool default_file = false);

  bool Parse(bool default_file = false);
  const char *GetParseError() const { return m_err.Get(); }

  void SetRelaunch(bool enable) { m_relaunch = enable; }
  bool WantRelaunch() const { return m_relaunch; }

  bool WantCurses() const;
  bool WantCursesRightFocus() const;
  int GetAudioSystem() const;
  double GetAudioDeviceSamplerate() const;
  int GetAudioDeviceBitDepth() const;
  int GetAudioDeviceOutputChannels() const;
  int GetMediaBufferSize() const;
  void GetDiskReadMode(int *rmode, int *rbufsize, int *rnbufs) const;
  void GetDiskWriteMode(int *wmode, int *wbufsize, int *wminbufs, int *wmaxbufs) const;
  int GetDiskIOPriority() const;
  int GetDiskIOSleepStep() const;
  int GetAntidoteBitDepth() const;
  void GetResampleMode(bool *interp, int *filtercnt, bool *sinc,
    int *sinc_size, int *sinc_interpsize) const;
  int GetRenderSystemPriority() const;
  int GetRenderSystemSleepStep() const;
  bool GetWASAPIExclusiveMode() const;
  double GetVolumeStep() const;
  bool WantEBUR128() const;
  bool WantDownwardOnly() const;
  double GetEBUR128LUFS() const;
  int GetEBUR128Mode() const;
  bool WantPreserveDirectory() const;
  void GetMediaLibraryPaths(WDL_PtrList_DeleteOnDestroy<WDL_FastString> **paths) const;
  int GetDatabaseSearchQueryLimit() const;
  double GetShift() const;
  double GetTempo() const;
  double GetAltShift() const;
  double GetAltTempo() const;
  double GetPreAllocatePeaks() const;

private:
  cJSON *m_pf;
  WDL_FastString m_err;
  bool m_relaunch;
};

#endif // _RHEA_PREFERENCES_H_
