// Copyright (c) 2023 Giorgos Vougioukas
//
// The license can be found in the LICENSE file.

#ifndef _RHEA_SEARCH_WND_H_
#define _RHEA_SEARCH_WND_H_

#include "rhea/definitions.h"

#include "WDL/heapbuf.h"
#include "WDL/wdlstring.h"
#include "WDL/wingui/wndsize.h"

class RHEA_SearchWnd
{
public:
  RHEA_SearchWnd();
  ~RHEA_SearchWnd();

  HWND Handle() const { return m_hwnd; }

  void Search();

  static WDL_DLGRET SearchWndProc(HWND hwnd, UINT msg, WPARAM wparam, LPARAM lparam);
private:
  void LoadMedia(bool deck, int index);
  void OnInitDialog(WPARAM wparam, LPARAM lparam);
  void OnDestroy(WPARAM wparam, LPARAM lparam);
  void OnSize(WPARAM wparam, LPARAM lparam);
  void OnMove(WPARAM wparam, LPARAM lparam);
  void OnCommand(WPARAM wparam, LPARAM lparam);
  void OnSysCommand(WPARAM wparam, LPARAM lparam);
  void OnTimer(WPARAM wparam, LPARAM lparam);
  void OnPaint(WPARAM wparam, LPARAM lparam);
  void OnContextMenu(WPARAM wparam, LPARAM lparam);
  INT_PTR OnNotify(WPARAM wparam, LPARAM lparam);
  WDL_DLGRET SearchWndLoop(UINT msg, WPARAM wparam, LPARAM lparam);
  static WDL_DLGRET NewListProc(HWND hwnd, UINT msg, WPARAM wparam, LPARAM lparam);
  static WDL_DLGRET NewEditProc(HWND hwnd, UINT msg, WPARAM wparam, LPARAM lparam);

  HWND m_hwnd;
  WDL_WndSizer m_resize;
  int m_x, m_y, m_w, m_h;

  HWND m_edit;
  HWND m_list;

  struct ColumnHeader
  {
    int id;
    const char *text;
    int width;
    int fmt;
    int sort_dir; // 1 ascending, -1 descending
    int sort_type; // 0 text, 1 numeric
  };

  WDL_TypedBuf<ColumnHeader> m_column_header;
  HMENU m_column_menu;
  HMENU m_matches_menu;
  WDL_FastString m_strbuf;
};

#endif // _RHEA_SEARCH_WND_H_
