// Copyright (c) 2023 Giorgos Vougioukas
//
// The license can be found in the LICENSE file.

#ifndef _RHEA_DECK_WND_H_
#define _RHEA_DECK_WND_H_

#include "rhea/definitions.h"

#include "WDL/heapbuf.h"
#include "WDL/wdlstring.h"
#include "WDL/wingui/wndsize.h"
#include "WDL/wingui/virtwnd.h"
#include "WDL/lice/lice_text.h"
#include "WDL/wingui/virtwnd-controls.h"

class RHEA_TrackWnd
{
public:
  RHEA_TrackWnd(bool deck, int index);
  ~RHEA_TrackWnd();

  HWND Handle() const { return m_hwnd; }

  void Select(bool enable);

  static WDL_DLGRET TrackWndProc(HWND hwnd, UINT msg, WPARAM wparam, LPARAM lparam);
private:
  void OnInitDialog(WPARAM wparam, LPARAM lparam);
  void OnDestroy(WPARAM wparam, LPARAM lparam);
  void OnSize(WPARAM wparam, LPARAM lparam);
  void OnCommand(WPARAM wparam, LPARAM lparam);
  void OnTimer(WPARAM wparam, LPARAM lparam);
  void OnPaint(WPARAM wparam, LPARAM lparam);
  WDL_DLGRET TrackWndLoop(UINT msg, WPARAM wparam, LPARAM lparam);

  HWND m_hwnd;
  WDL_WndSizer m_resize;
  bool m_deck;
  int m_idx;

  WDL_FastString m_infostr;
  bool m_medialoading;
  WDL_VWnd_Painter m_painter;
  LICE_IBitmap *m_bm;
  LICE_IFont *m_font;
  LICE_IFont *m_bigfont;

  enum
  {
    INFO,
    TIME,
    TITLE,
    ARTIST
  };

  WDL_VWnd m_vwnd;
  WDL_VirtualStaticText *m_info;
  WDL_VirtualStaticText *m_time;
  WDL_VirtualStaticText *m_title;
  WDL_VirtualStaticText *m_artist;
  WDL_FastString m_strbuf;
};

#endif // _RHEA_DECK_WND_H_
