// Copyright (c) 2023 Giorgos Vougioukas
//
// The license can be found in the LICENSE file.

#ifndef _RHEA_WAVEFORM_WND_H_
#define _RHEA_WAVEFORM_WND_H_

#include "rhea/definitions.h"
#include "rhea/waveform.h"

//#define RHEA_ENSUREVISIBLE (WM_USER + 200)

#include "WDL/heapbuf.h"
#include "WDL/wdlstring.h"
#include "WDL/wingui/wndsize.h"
#include "WDL/wingui/virtwnd.h"

class RHEA_WaveformWnd
{
public:
  explicit RHEA_WaveformWnd(HWND hwnd);
  ~RHEA_WaveformWnd();

  HWND Handle() const { return m_hwnd; }
  void EnsureVisible(bool deck, int index);
  static WDL_DLGRET WaveformWndProc(HWND hwnd, UINT msg, WPARAM wparam, LPARAM lparam);
private:
  void OnCreate(WPARAM wparam, LPARAM lparam);
  void OnDestroy(WPARAM wparam, LPARAM lparam);
  void OnSize(WPARAM wparam, LPARAM lparam);
  void OnCommand(WPARAM wparam, LPARAM lparam);
  void OnPaint(WPARAM wparam, LPARAM lparam);
  void OnLButtonDown(WPARAM wparam, LPARAM lparam);
  void OnLButtonUp(WPARAM wparam, LPARAM lparam);
  void OnMouseMove(WPARAM wparam, LPARAM lparam);
  void OnTimer(WPARAM wparam, LPARAM lparam);
  void OnVScroll(WPARAM wparam, LPARAM lparam);
  void OnKeyDown(WPARAM wparam, LPARAM lparam);
  void OnMouseWheel(WPARAM wparam, LPARAM lparam);
  WDL_DLGRET WaveformWndLoop(UINT msg, WPARAM wparam, LPARAM lparam);

  HWND m_hwnd;
  WDL_WndSizer m_resize;
  WDL_VirtualWnd_Painter m_painter;

  RHEA_Waveform m_wf;
};

#endif // _RHEA_WAVEFORM_WND_H_
