// Copyright (c) 2019 Giorgos Vougioukas
//
// The license can be found in the LICENSE file.

#ifndef _RHEA_AUDIO_STREAMER_DIRECTSOUND_DEVICE_H_
#define _RHEA_AUDIO_STREAMER_DIRECTSOUND_DEVICE_H_

#include "rhea/rhea_plugin.h"

#include <portaudio.h>

#include "WDL/assocarray.h"

extern HINSTANCE directsound_instance;

class RHEA_DirectSoundDevice : public RHEA_IAudioStreamerDevice
{
public:
  RHEA_DirectSoundDevice();
  ~RHEA_DirectSoundDevice();

  void Scan();

  int GetDefaultInputDevice() const;
  int GetDefaultOutputDevice() const;

  //WDL_IntKeyedArray<const char *> input_dev;
  //WDL_IntKeyedArray<const char *> output_dev;

private:
  PaError m_error;

  int m_default_input_dev;
  int m_default_output_dev;

  PaHostApiTypeId m_host_api_id;
};

#endif // _RHEA_AUDIO_STREAMER_DIRECTSOUND_DEVICE_H_
