// Copyright (c) 2020 Giorgos Vougioukas
//
// The license can be found in the LICENSE file.

#include "rhea/rhea_plugin.h"
#include "rhea_directsound/audio_streamer_ds.h"
#include "rhea_directsound/audio_streamer_ds_dev.h"

#if defined(_WIN32) && defined(_DEBUG)
#include <vld.h>
#endif

#include "WDL/wdlcstring.h"

int (*RHEA_GetAudioSystem)();
double (*RHEA_GetAudioDeviceSamplerate)();
int (*RHEA_GetAudioDeviceBitDepth)();
int (*RHEA_GetAudioDeviceOutputChannels)();

HINSTANCE directsound_instance;
static HWND directsound_main_hwnd;

RHEA_IAudioStreamer *CreateAudioStreamer()
{
  if (RHEA_GetAudioSystem() == 1)
  {
    return new RHEA_DirectSound;
  }

  return NULL;
}

RHEA_AudioStreamerRegister directsound_reg =
{
  &CreateAudioStreamer
};

RHEA_IAudioStreamerDevice *CreateAudioStreamerDevice()
{
  return new RHEA_DirectSoundDevice;
}

RHEA_AudioStreamerDeviceRegister directsound_dev_reg =
{
  &CreateAudioStreamerDevice
};

extern "C"
{
  RHEA_PLUGIN_EXPORT int RHEA_PLUGIN_ENTRYPOINT(
    RHEA_PLUGIN_HINSTANCE instance, RHEA_PluginInfo *rec)
  {
    directsound_instance = instance;

    if (rec)
    {
      if (rec->caller_version != RHEA_PLUGIN_VERSION || !rec->GetFunc)
      {
        return 0;
      }

      directsound_main_hwnd = rec->hwnd_main;

      *((void **)&RHEA_GetAudioSystem) = rec->GetFunc("RHEA_GetAudioSystem");
      *((void **)&RHEA_GetAudioDeviceSamplerate) = rec->GetFunc("RHEA_GetAudioDeviceSamplerate");
      *((void **)&RHEA_GetAudioDeviceBitDepth) = rec->GetFunc("RHEA_GetAudioDeviceBitDepth");
      *((void **)&RHEA_GetAudioDeviceOutputChannels) = rec->GetFunc("RHEA_GetAudioDeviceOutputChannels");

      if (!rec->Register || !RHEA_GetAudioSystem || !RHEA_GetAudioDeviceSamplerate ||
        !RHEA_GetAudioDeviceBitDepth || ! RHEA_GetAudioDeviceOutputChannels)
      {
        return 0;
      }

      rec->Register("audio_streamer", &directsound_reg);
      rec->Register("audio_streamer_device", &directsound_dev_reg);

      return 1;
    }
    else
    {
      return 0;
    }
  }
}
