// Copyright (c) 2019 Giorgos Vougioukas
//
// The license can be found in the LICENSE file.

#if defined(_WIN32) && defined(_DEBUG)
#include <vld.h>
#endif

//#define ENABLE_RHEA_FLAC_CONSOLE

#include "rhea/rhea_plugin_public.h"
#include "rhea_flac/flac_input.h"
#include "rhea_flac/flac_apic.h"
#include "rhea_flac/flac_tag.h"

#include "WDL/wdlcstring.h"

double (*RHEA_GetAudioDeviceSamplerate)();
void (*RHEA_GetDiskReadMode)(int *rmode, int *rbufsize, int *rnbufs);
void (*RHEA_GetResampleMode)(bool *interp, int *filtercnt,
  bool *sinc, int *sinc_size, int *sinc_interpsize);

static HINSTANCE flac_instance;
static HWND flac_main_hwnd;

RHEA_IFileInput *CreateFromType(const char *type)
{
  if (!strcmp(type, "FLAC"))
  {
    return new RHEA_FlacInput;
  }

  return NULL;
}

RHEA_IFileInput *CreateFromFile(const char *filename)
{
  if (!wdl_filename_cmp(WDL_get_fileext(filename), ".flac"))
  {
    RHEA_FlacInput *p = new RHEA_FlacInput;

    if (p->Open(filename))
    {
      return p;
    }

    delete p;
  }

  return NULL;
}

struct RHEA_FileInputRegister flac_input_reg =
{
  CreateFromType,
  CreateFromFile,
};

RHEA_IFileTag *CreateFlacTag(const char *filename)
{
  if (!wdl_filename_cmp(WDL_get_fileext(filename), ".flac"))
  {
    RHEA_FlacTag *p = new RHEA_FlacTag;

    if (p && p->Open(filename))
    {
      return p;
    }
    else
    {
      delete p;
    }
  }

  return NULL;
}

RHEA_FileTagRegister flac_tag_reg =
{
  &CreateFlacTag
};

RHEA_IFilePic *CreateFlacAPIC(const char *filename)
{
  if (!wdl_filename_cmp(WDL_get_fileext(filename), ".flac"))
  {
    RHEA_FlacAPIC *p = new RHEA_FlacAPIC;

    if (p->Open(filename))
    {
      return p;
    }
    else
    {
      delete p;
    }
  }

  return NULL;
}

RHEA_FilePicRegister flac_apic_reg =
{
  &CreateFlacAPIC
};

extern "C"
{
  RHEA_PLUGIN_EXPORT int RHEA_PLUGIN_ENTRYPOINT(
    RHEA_PLUGIN_HINSTANCE instance, RHEA_PluginInfo *rec)
  {
#if defined(_WIN32) && defined(_DEBUG) && defined(ENABLE_RHEA_FLAC_CONSOLE)
    // The first will use the console only if
    // the application is started by the command 
    // line. The second one will always enable
    // the console.
    //if (AttachConsole(ATTACH_PARENT_PROCESS))
    if (AttachConsole(ATTACH_PARENT_PROCESS) || AllocConsole())
    {
        freopen("CONOUT$", "w", stdout);
        freopen("CONOUT$", "w", stderr);
    }
#endif

    flac_instance = instance;

    if (rec)
    {
      if (rec->caller_version != RHEA_PLUGIN_VERSION || !rec->GetFunc)
      {
        return 0;
      }

      flac_main_hwnd = rec->hwnd_main;

      *((void **)&RHEA_GetAudioDeviceSamplerate) = rec->GetFunc("RHEA_GetAudioDeviceSamplerate");
      *((void **)&RHEA_GetDiskReadMode) = rec->GetFunc("RHEA_GetDiskReadMode");
      *((void **)&RHEA_GetResampleMode) = rec->GetFunc("RHEA_GetResampleMode");

      if (!rec->Register || !RHEA_GetAudioDeviceSamplerate || !RHEA_GetDiskReadMode ||
        !RHEA_GetResampleMode)
      {
        return 0;
      }

      rec->Register("input", &flac_input_reg);
      rec->Register("tag", &flac_tag_reg);
      //rec->Register("apic", &flac_apic_reg);

      return 1;
    }
    else
    {
      return 0;
    }
  }
}
