// Copyright (c) 2022 Giorgos Vougioukas
//
// The license can be found in the LICENSE file.

#ifndef _RHEA_OPUS_ENTRY_POINT_H_
#define _RHEA_OPUS_ENTRY_POINT_H_

#include <opusfile.h>

extern double (*RHEA_GetAudioDeviceSamplerate)();
extern void (*RHEA_GetDiskReadMode)(int *rmode, int *rbufsize, int *rnbufs);
extern void (*RHEA_GetResampleMode)(bool *interp, int *filtercnt,
  bool *sinc, int *sinc_size, int *sinc_interpsize);

extern int tha_seek(void *user_data, opus_int64 offset, int whence);
extern int tha_read(void *user_data, unsigned char *ptr, int count);
extern opus_int64 tha_tell(void *user_data);

#endif // _RHEA_OPUS_ENTRY_POINT_H_
