// Copyright (c) 2020 Giorgos Vougioukas
//
// The license can be found in the LICENSE file.

#include "rhea/rhea_plugin.h"
#include "rhea_wasapi/audio_streamer_wasapi.h"
#include "rhea_wasapi/audio_streamer_wasapi_dev.h"

#if defined(_WIN32) && defined(_DEBUG)
#include <vld.h>
#endif

#include "WDL/wdlcstring.h"

int (*RHEA_GetAudioSystem)();
double (*RHEA_GetAudioDeviceSamplerate)();
int (*RHEA_GetAudioDeviceBitDepth)();
int (*RHEA_GetAudioDeviceOutputChannels)();
bool (*RHEA_GetWASAPIExclusiveMode)();

HINSTANCE wasapi_instance;
static HWND wasapi_main_hwnd;

RHEA_IAudioStreamer *CreateAudioStreamer()
{
  if (RHEA_GetAudioSystem() == 2)
  {
    return new RHEA_Wasapi;
  }

  return NULL;
}

RHEA_AudioStreamerRegister wasapi_reg =
{
  &CreateAudioStreamer
};

RHEA_IAudioStreamerDevice *CreateAudioStreamerDevice()
{
  return new RHEA_WasapiDevice;
}

RHEA_AudioStreamerDeviceRegister wasapi_dev_reg =
{
  &CreateAudioStreamerDevice
};

extern "C"
{
  RHEA_PLUGIN_EXPORT int RHEA_PLUGIN_ENTRYPOINT(
    RHEA_PLUGIN_HINSTANCE instance, RHEA_PluginInfo *rec)
  {
    wasapi_instance = instance;

    if (rec)
    {
      if (rec->caller_version != RHEA_PLUGIN_VERSION || !rec->GetFunc)
      {
        return 0;
      }

      wasapi_main_hwnd = rec->hwnd_main;

      *((void **)&RHEA_GetAudioSystem) = rec->GetFunc("RHEA_GetAudioSystem");
      *((void **)&RHEA_GetAudioDeviceSamplerate) = rec->GetFunc("RHEA_GetAudioDeviceSamplerate");
      *((void **)&RHEA_GetAudioDeviceBitDepth) = rec->GetFunc("RHEA_GetAudioDeviceBitDepth");
      *((void **)&RHEA_GetAudioDeviceOutputChannels) = rec->GetFunc("RHEA_GetAudioDeviceOutputChannels");
      *((void **)&RHEA_GetWASAPIExclusiveMode) = rec->GetFunc("RHEA_GetWASAPIExclusiveMode");

      if (!rec->Register || !RHEA_GetAudioSystem || !RHEA_GetAudioDeviceSamplerate ||
        !RHEA_GetAudioDeviceBitDepth || !RHEA_GetAudioDeviceOutputChannels ||
        !RHEA_GetWASAPIExclusiveMode)
      {
        return 0;
      }

      rec->Register("audio_streamer", &wasapi_reg);
      rec->Register("audio_streamer_device", &wasapi_dev_reg);

      return 1;
    }
    else
    {
      return 0;
    }
  }
}
