// Copyright (c) 2019 Giorgos Vougioukas
//
// The license can be found in the LICENSE file.

#ifndef _RHEA_AUDIO_STREAMER_WAVEOUT_H_
#define _RHEA_AUDIO_STREAMER_WAVEOUT_H_

#include <windows.h>

#include <portaudio.h>
#include <pa_win_wmme.h>
#include <pa_util.h>

#include "rhea/rhea_plugin.h"

#include "WDL/heapbuf.h"
#include "WDL/queue.h"
#include "WDL/wdlstring.h"

class RHEA_WaveOut : public RHEA_IAudioStreamer
{
public:
  RHEA_WaveOut();
  ~RHEA_WaveOut();

  bool Open();
  void Start(RHEA_AudioCallback callback);
  void Stop();
  void Close();
  bool IsRunning() const;
  double GetSampleRate() const;
  int GetChannels() const;

private:
  static int pa_callback(const void *input, void *output, unsigned long frame_count,
    const PaStreamCallbackTimeInfo *time_info, PaStreamCallbackFlags status_flags,
    void *user_data);

  PaError m_error;
  PaStream *m_stream;
  bool m_running;

  RHEA_AudioCallback m_callback;

  int m_sample_fmt;
  int m_samplerate;
  int m_output_nch;
  int m_output_dev;

  WDL_TypedBuf<SAM> m_buffer;
  WDL_HeapBuf m_pcm;
};

#endif // _RHEA_AUDIO_STREAMER_WAVEOUT_H_
