// Copyright (c) 2022 Giorgos Vougioukas
//
// The license can be found in the LICENSE file.

#ifndef _RHEA_WAVPACK_ENTRY_POINT_H_
#define _RHEA_WAVPACK_ENTRY_POINT_H_

#include <wavpack.h>

extern double (*RHEA_GetAudioDeviceSamplerate)();
extern void (*RHEA_GetDiskReadMode)(int *rmode, int *rbufsize, int *rnbufs);
extern void (*RHEA_GetResampleMode)(bool *interp, int *filtercnt,
  bool *sinc, int *sinc_size, int *sinc_interpsize);

extern int32_t tha_read_bytes(void *id, void *data, int32_t bcount);
extern int32_t tha_write_bytes(void *id, void *data, int32_t bcount);
extern int64_t tha_get_pos(void *id); // new signature for large files
extern int tha_set_pos_abs(void *id, int64_t pos); // new signature for large files
extern int tha_set_pos_rel(void *id, int64_t delta, int mode); // new signature for large files
extern int tha_push_back_byte(void *id, int c);
extern int64_t tha_get_length(void *id); // new signature for large files
extern int tha_can_seek(void *id);
extern int tha_truncate_here(void *id); // new function to truncate file at current position
extern int tha_close(void *id); // new function to close file

#endif // _RHEA_WAVPACK_ENTRY_POINT_H_
