rem Retrieve major/minor version
rem ============================

setlocal enabledelayedexpansion

for /f "delims=" %%a in ('findstr /b /c:"#define RSI_MAJOR_VERSION " ..\..\src\RSI\app_info.h') do (
  set pwd=%%a
  set "pwd=!pwd:Password: =!"
)

set major_ver="%pwd%"
set maj=%major_ver:~27,1%

for /f "delims=" %%a in ('findstr /b /c:"#define RSI_MINOR_VERSION " ..\..\src\RSI\app_info.h') do (
  set pwd=%%a
  set "pwd=!pwd:Password: =!"
)

set minor_ver="%pwd%"
set min=%minor_ver:~27,2%

for /f "delims=" %%a in ('findstr /b /c:"#define RSI_RELEASE " ..\..\src\RSI\app_info.h') do (
  set pwd=%%a
  set "pwd=!pwd:Password: =!"
)

set release="%pwd%"
set rel=%release:~22%

rmdir /s /q build
rmdir /s /q src
del /s /q rsi-soundtouch*.zip

mkdir build
mkdir build\vc
mkdir build\linux
mkdir src
mkdir src\WDL-GV
mkdir src\RSI
mkdir src\rsi_soundtouch

xcopy /y /s ..\..\src\WDL-GV src\WDL-GV
xcopy /y ..\..\src\RSI\rsi_plugin_public.h src\RSI
xcopy /y ..\..\src\RSI\sample_format.h src\RSI
xcopy /y ..\..\build\vc\rsi-soundtouch.* build\vc
xcopy /y ..\..\build\linux\makefile_rsi_soundtouch.mk build\linux
xcopy /y ..\..\build\linux\Makefile build\linux
xcopy /y /s ..\..\src\rsi_soundtouch src\rsi_soundtouch

7z a -tzip -mx=1 rsi-soundtouch-%maj%.%min%%rel%-src.zip build
7z a -tzip -mx=1 rsi-soundtouch-%maj%.%min%%rel%-src.zip src
7z d -r rsi-soundtouch-%maj%.%min%%rel%-src.zip build\vc\Win32
7z d -r rsi-soundtouch-%maj%.%min%%rel%-src.zip build\vc\x64
7z d -r rsi-soundtouch-%maj%.%min%%rel%-src.zip *.o
7z t rsi-soundtouch-%maj%.%min%%rel%-src.zip * -r

rmdir /s /q build
rmdir /s /q src

pause
