rem Cleanup
rem =======

del *.zip
del *.exe
del changelog.txt

copy ..\doc\changelog.txt .\

rem RSI x86 (installer)
rem ===================

makensis rsi_x86.nsi

rem RSI x64 (installer)
rem ===================

makensis rsi_x64.nsi

rem Retrieve major/minor version
rem ============================

setlocal enabledelayedexpansion

for /f "delims=" %%a in ('findstr /b /c:"#define RSI_MAJOR_VERSION " ..\src\rsi\app_info.h') do (
  set pwd=%%a
  set "pwd=!pwd:Password: =!"
)

set major_ver="%pwd%"
set maj=%major_ver:~27,1%

for /f "delims=" %%a in ('findstr /b /c:"#define RSI_MINOR_VERSION " ..\src\rsi\app_info.h') do (
  set pwd=%%a
  set "pwd=!pwd:Password: =!"
)

set minor_ver="%pwd%"
set min=%minor_ver:~27,2%

for /f "delims=" %%a in ('findstr /b /c:"#define RSI_RELEASE " ..\src\rsi\app_info.h') do (
  set pwd=%%a
  set "pwd=!pwd:Password: =!"
)

set release="%pwd%"
set rel=%release:~22%

rem rsi x86 (portable)
rem =====================

rem Note: -mx=1 (fastest), -mx=3 (fast), nothing or -mx=5 (normal)

7z a -tzip -mx=1 rsi-%maj%.%min%%rel%-x86.zip ..\build\vc\Win32\Release\rsi.exe
7z a -tzip -mx=1 rsi-%maj%.%min%%rel%-x86.zip ..\build\vc\Win32\Release\ext\
7z a -tzip -mx=1 rsi-%maj%.%min%%rel%-x86.zip ..\build\vc\Win32\Release\skin\
7z a -tzip -mx=1 rsi-%maj%.%min%%rel%-x86.zip ..\build\vc\Win32\Release\*.dll
7z a -tzip -mx=1 rsi-%maj%.%min%%rel%-x86.zip ..\build\vc\Win32\Release\changelog.txt
7z a -tzip -mx=1 rsi-%maj%.%min%%rel%-x86.zip ..\build\vc\Win32\Release\license.txt
7z a -tzip -mx=1 rsi-%maj%.%min%%rel%-x86.zip ..\build\vc\Win32\Release\documentation.txt
7z a -tzip -mx=1 rsi-%maj%.%min%%rel%-x86.zip portable
7z d -r rsi-%maj%.%min%%rel%-x86.zip *.lib
7z d -r rsi-%maj%.%min%%rel%-x86.zip *.pdb
7z d -r rsi-%maj%.%min%%rel%-x86.zip *.exp
7z t rsi-%maj%.%min%%rel%-x86.zip * -r

rem rsi x64 (portable)
rem =====================

7z a -tzip -mx=1 rsi-%maj%.%min%%rel%-x64.zip ..\build\vc\x64\Release\rsi.exe
7z a -tzip -mx=1 rsi-%maj%.%min%%rel%-x64.zip ..\build\vc\x64\Release\ext\
7z a -tzip -mx=1 rsi-%maj%.%min%%rel%-x64.zip ..\build\vc\x64\Release\skin\
7z a -tzip -mx=1 rsi-%maj%.%min%%rel%-x64.zip ..\build\vc\x64\Release\*.dll
7z a -tzip -mx=1 rsi-%maj%.%min%%rel%-x64.zip ..\build\vc\x64\Release\changelog.txt
7z a -tzip -mx=1 rsi-%maj%.%min%%rel%-x64.zip ..\build\vc\x64\Release\license.txt
7z a -tzip -mx=1 rsi-%maj%.%min%%rel%-x64.zip ..\build\vc\x64\Release\documentation.txt
7z a -tzip -mx=1 rsi-%maj%.%min%%rel%-x64.zip portable
7z d -r rsi-%maj%.%min%%rel%-x64.zip *.lib
7z d -r rsi-%maj%.%min%%rel%-x64.zip *.pdb
7z d -r rsi-%maj%.%min%%rel%-x64.zip *.exp
7z t rsi-%maj%.%min%%rel%-x64.zip * -r

cd ..
git archive --format=zip --prefix=GV-891/ HEAD > pack\rsi-%maj%.%min%%rel%-src.zip
git archive --format=tar.gz --prefix=GV-891/ HEAD > pack\rsi-%maj%.%min%%rel%-src.tar.gz

pause
