// Copyright (c) 2021 Giorgos Vougioukas
//
// The license can be found in the LICENSE file.

#ifndef _RSI_INFO_H_
#define _RSI_INFO_H_

#include <string.h>

#include "RSI/git_sha1.h"

#define RSI_MAJOR_VERSION 1
#define RSI_MINOR_VERSION 05

#define RSI_RELEASE ""
#define RSI_SPECIAL ""

#define RSI_NAME "rsi"
#define RSI_NAME_MARKETING "RSI"
#define RSI_COMPANY_URL "https://www.grafmin.gr/"
#define RSI_WEBSITE_URL "https://www.grafmin.gr/rsi"
#define RSI_COPYRIGHT "Copyright (c) 2022-2025 Giorgos Vougioukas"

#define RSI_STRINGIFY_HELPER(x) #x
#define RSI_STRINGIFY(x) RSI_STRINGIFY_HELPER(x)

#define RSI_NAKED_VERSION \
  RSI_STRINGIFY(RSI_MAJOR_VERSION) \
  "." RSI_STRINGIFY(RSI_MINOR_VERSION) \
  RSI_RELEASE RSI_SPECIAL

#define RSI_FULL_VERSION \
  RSI_NAME_MARKETING " " RSI_NAKED_VERSION

#define RSI_GIT_SHA RSI_STRINGIFY(GIT_SHA1)

#define RSI_TIMESTAMP __DATE__ " " __TIME__

inline bool IsStableRelease()
{
  if (strlen(RSI_RELEASE)) return false;

  return true;
}

#if defined(_MSC_VER)
  #if defined(_M_AMD64) || defined(_M_X64)
    #define RSI_ARCH "x64"
  #elif defined(_M_IX86)
    #define RSI_ARCH "x86"
  #else
    #define RSI_ARCH "unk"
  #endif
#elif defined(__linux__) && (defined(__clang__) || defined(__GNUC__))
  #if defined(__amd64__) || defined(__X86_64__)
    #define RSI_ARCH "amd64"
  #elif defined(__i386__)
    #define RSI_ARCH "i686"
  #else
    #define RSI_ARCH "unk"
  #endif
#elif defined(__APPLE__) && (defined(__clang__) || defined(__GNUC__))
  #if defined(__amd64__) || defined(__X86_64__)
    #define RSI_ARCH "x86-64"
  #elif defined(__i386__)
    #define RSI_ARCH "i386"
  #else
    #define RSI_ARCH "unk"
  #endif
#endif

#endif // _RSI_INFO_H_
