// Copyright (c) 2021 Giorgos Vougioukas
//
// The license can be found in the LICENSE file.

#include "RSI/definitions.h"
#include "RSI/preferences.h"
#include "RSI/render_system.h"
#include "RSI/data_bank.h"
#include "RSI/track.h"
#include "RSI/track_wnd.h"
#include "RSI/about_wnd.h"
#include "RSI/changelog_wnd.h"
#include "RSI/license_wnd.h"
#include "RSI/load_wnd.h"
#include "RSI/main_wnd.h"
#include "RSI/preferences_wnd.h"
#include "RSI/stats_wnd.h"
#include "RSI/skin.h"
#include "RSI/library_wnd.h"
//#include "RSI/rsi_plugin.h"

static void free_str(const char *p) { free((void *)p); }
static void delete_track(RSI_Track *p) { delete p; }

HINSTANCE g_inst = NULL;
UINT g_scrollmessage;
bool g_hasrequestedquit = false;

WDL_FastString g_modpath;
WDL_FastString g_setpath;
WDL_FastString g_inipath;
WDL_FastString g_media_ext(".flac .mp3");

RSI_DataBank *g_databank = NULL;
RSI_Preferences *g_preferences = NULL;
RSI_RenderSystem *g_rendersystem = NULL;
RSI_IAudioStreamer *g_audiostreamer = NULL;
WDL_IntKeyedArray<RSI_Track *> g_tracks(delete_track);
RSI_Skin g_skin;

RSI_MainWnd *g_mainwnd = NULL;
RSI_LicenseWnd *g_licwnd = NULL;
RSI_ChangelogWnd *g_changelogwnd = NULL;
RSI_PreferencesWnd *g_prefwnd = NULL;
RSI_AboutWnd *g_aboutwnd = NULL;
HWND g_loadwnd = NULL;
WDL_PtrList<RSI_TrackWnd> g_trackwnds;
RSI_StatsWnd *g_statswnd = NULL;
RSI_LibraryWnd *g_librarywnd = NULL;

WDL_PtrKeyedArray<const char *> g_pluginimport(free_str);
WDL_StringKeyedArray<void *> g_pluginexport;

void RSI_AudioOnSamples(WDL_TypedBuf<SAM> *output, int frame_count, int nch)
{
  g_rendersystem->AudioStreamerData(output, frame_count, nch);
}

double RSI_GetAudioDeviceSamplerate() { return g_preferences->GetAudioDeviceSamplerate(); }
int RSI_GetAudioDeviceBitDepth() { return g_preferences->GetAudioDeviceBitDepth(); }
int RSI_GetAudioDeviceOutputChannels() { return g_preferences->GetAudioDeviceOutputChannels(); }

void RSI_GetDiskReadMode(int *rmode, int *rbufsize, int *rnbufs)
{
  g_preferences->GetDiskReadMode(rmode, rbufsize, rnbufs);
}

void RSI_GetDiskWriteMode(int *wmode, int *wbufsize, int *wminbufs, int *wmaxbufs)
{
  g_preferences->GetDiskWriteMode(wmode, wbufsize, wminbufs, wmaxbufs);
}

int RSI_GetDiskIOPriority() { return g_preferences->GetDiskIOPriority(); }
int RSI_GetDiskIOSleepStep() { return g_preferences->GetDiskIOSleepStep(); }
int RSI_GetAntidoteBitDepth() { return g_preferences->GetAntidoteBitDepth(); }
int RSI_GetAudioSystem() { return g_preferences->GetAudioSystem(); }

void RSI_GetResampleMode(bool *interp, int *filtercnt,
  bool *sinc, int *sinc_size, int *sinc_interpsize)
{
  g_preferences->GetResampleMode(interp, filtercnt, sinc, sinc_size, sinc_interpsize);
}

bool RSI_GetWASAPIExclusiveMode() { return g_preferences->GetWASAPIExclusiveMode(); }
