// Copyright (c) 2021 Giorgos Vougioukas
//
// The license can be found in the LICENSE file.

#ifndef _RSI_DEFINITIONS_H_
#define _RSI_DEFINITIONS_H_

#if defined(_WIN32)
#include <windows.h>
#include <windowsx.h>
#include <commctrl.h>
#include <process.h>
#else
#include "WDL/swell/swell.h"
#include "WDL/swell/swell-functions.h"
#endif

#include "RSI/res/resource.h"
#include "RSI/sample_format.h"

#include "WDL/wdltypes.h"
#include "WDL/win32_utf8.h"
#include "WDL/heapbuf.h"
#include "WDL/ptrlist.h"
#include "WDL/wdlstring.h"
#include "WDL/assocarray.h"

#define RSI_MAX_TRACKS 12

class RSI_DataBank;
class RSI_Preferences;
class RSI_RenderSystem;
class RSI_IAudioStreamer;
class RSI_Track;
class RSI_TrackWnd;
class RSI_AboutWnd;
class RSI_ChangelogWnd;
class RSI_LicenseWnd;
class RSI_LoadWnd;
class RSI_MainWnd;
class RSI_PreferencesWnd;
class RSI_StatsWnd;
class RSI_Skin;
class RSI_LibraryWnd;

extern HINSTANCE g_inst;
extern UINT g_scrollmessage;
extern bool g_hasrequestedquit;

extern WDL_FastString g_modpath;
extern WDL_FastString g_setpath;
extern WDL_FastString g_inipath;
extern WDL_FastString g_media_ext;

extern RSI_DataBank *g_databank;
extern RSI_Preferences *g_preferences;
extern RSI_RenderSystem *g_rendersystem;
extern RSI_IAudioStreamer *g_audiostreamer;
extern WDL_IntKeyedArray<RSI_Track *> g_tracks;
extern RSI_Skin g_skin;

extern RSI_MainWnd *g_mainwnd;
extern RSI_LicenseWnd *g_licwnd;
extern RSI_ChangelogWnd *g_changelogwnd;
extern RSI_PreferencesWnd *g_prefwnd;
extern RSI_AboutWnd *g_aboutwnd;
extern HWND g_loadwnd;
extern WDL_PtrList<RSI_TrackWnd> g_trackwnds;
extern RSI_StatsWnd *g_statswnd;
extern RSI_LibraryWnd *g_librarywnd;

extern WDL_PtrKeyedArray<const char *> g_pluginimport;
extern WDL_StringKeyedArray<void *> g_pluginexport;

extern WDL_DLGRET RSI_WaveformAWndProc(HWND hwnd, UINT msg, WPARAM wparam, LPARAM lparam);
extern WDL_DLGRET RSI_WaveformBWndProc(HWND hwnd, UINT msg, WPARAM wparam, LPARAM lparam);
extern WDL_DLGRET RSI_LoadWndProc(HWND hwnd, UINT msg, WPARAM wparam, LPARAM lparam);

extern void RSI_RunMessageLoop();
extern int RSI_ProcessMessage(MSG *msg);
extern void RSI_AudioOnSamples(WDL_TypedBuf<SAM> *output, int frame_count, int nch);

extern double RSI_GetAudioDeviceSamplerate();
extern int RSI_GetAudioDeviceBitDepth();
extern int RSI_GetAudioDeviceOutputChannels();
extern void RSI_GetDiskReadMode(int *rmode, int *rbufsize, int *rnbufs);
extern void RSI_GetDiskWriteMode(int *wmode, int *wbufsize, int *wminbufs, int *wmaxbufs);
extern int RSI_GetDiskIOPriority();
extern int RSI_GetDiskIOSleepStep();
extern int RSI_GetAntidoteBitDepth();
extern int RSI_GetAudioSystem();
extern void RSI_GetResampleMode(bool *interp, int *filtercnt,
  bool *sinc, int *sinc_size, int *sinc_interpsize);
extern bool RSI_GetWASAPIExclusiveMode();

#endif // _RSI_DEFINITIONS_H_
