// Copyright (c) 2022 Giorgos Vougioukas
//
// The license can be found in the LICENSE file.

#ifndef _RSI_LIBRARY_WND_H_
#define _RSI_LIBRARY_WND_H_

#include "RSI/definitions.h"
#include "RSI/app_info.h"
#include "RSI/database.h"
#include "RSI/query.h"

#include "WDL/heapbuf.h"
#include "WDL/wdlstring.h"
#include "WDL/wingui/wndsize.h"
#include "WDL/wingui/virtwnd.h"

class RSI_LibraryWnd
{
public:
  RSI_LibraryWnd();
  ~RSI_LibraryWnd();

  HWND Handle() const { return m_hwnd; }
  void LoadFileTrack();
  void ShowSearch(bool show);
  bool IsShowSearch() const { return m_showsearch; }
  void Search();
  void ScanFiles();
  bool IsScanning() const;
  void AbortScanning();
  void ScanCompleted();
  const char *GetScanningStage() const;
  const char *GetScanningFilename() const;
  static WDL_DLGRET LibraryWndProc(HWND hwnd, UINT msg, WPARAM wparam, LPARAM lparam);
private:
  void FeedListView();
  void ClearListView();
  void OnInitDialog();
  void OnDestroy();
  void OnSize();
  void OnCommand();
  void OnContextMenu();
  void OnTimer();
  void OnNotify();
  void OnPaint();
  WDL_DLGRET LibraryWndLoop(UINT msg, WPARAM wparam, LPARAM lparam);
  static WDL_DLGRET NewListProc(HWND hwnd, UINT msg, WPARAM wparam, LPARAM lparam);
  static WDL_DLGRET NewEditProc(HWND hwnd, UINT msg, WPARAM wparam, LPARAM lparam);

  HWND m_hwnd;
  UINT m_msg;
  WPARAM m_wparam;
  LPARAM m_lparam;
  WDL_WndSizer m_resize;
  HWND m_list;
  HWND m_edit;

  struct ColumnHeader
  {
    int id;
    const char *text;
    int width;
    int fmt;
    int sort_dir; // 1 ascending, -1 descending
    int sort_type; // 0 text, 1 numeric
  };

  WDL_TypedBuf<ColumnHeader> m_column_header;

  HMENU m_context_menu;
  HMENU m_column_menu;
  int m_column;

  RSI_Database m_db;
  RSI_Query m_query;

  struct LastSortOrder
  {
    WDL_FastString col;
    int sort_dir; // 1 ascending, -1 descending
  };

  LastSortOrder m_lastsortorder;

  WDL_VirtualWnd_Painter m_painter;
  bool m_showsearch;

  WDL_FastString m_strbuf;
};

#endif // _RSI_LIBRARY_WND_H_
