// Copyright (c) 2022 Giorgos Vougioukas
//
// The license can be found in the LICENSE file.

#ifndef _RSI_LICENSE_WND_H_
#define _RSI_LICENSE_WND_H_

#include "RSI/definitions.h"
#include "RSI/app_info.h"

#include "WDL/fileread.h"
#include "WDL/wdlstring.h"
#include "WDL/wingui/wndsize.h"

class RSI_LicenseWnd
{
public:
  RSI_LicenseWnd()
    : m_hwnd(NULL)
  {}

  ~RSI_LicenseWnd()
  {
    DestroyWindow(m_hwnd);
  }

  HWND Handle() const { return m_hwnd; }
  static WDL_DLGRET LicenseWndProc(HWND hwnd, UINT msg, WPARAM wparam, LPARAM lparam);
private:
  void OnInitDialog();
#ifdef _WIN32
  INT_PTR OnCtlColorStatic();
#endif
  void OnDestroy();
  void OnSize();
  void OnCommand();
  WDL_DLGRET LicenseWndLoop(UINT msg, WPARAM wparam, LPARAM lparam);

  HWND m_hwnd;
  UINT m_msg;
  WPARAM m_wparam;
  LPARAM m_lparam;
  WDL_WndSizer m_resize;
};

#endif // _RSI_LICENSE_WND_H_
