// Copyright (c) 2022 Giorgos Vougioukas
//
// The license can be found in the LICENSE file.

#ifndef _RSI_MAIN_WND_H_
#define _RSI_MAIN_WND_H_

#include "RSI/definitions.h"

#include "WDL/wingui/wndsize.h"
#include "WDL/wingui/virtwnd.h"
#include "WDL/mutex.h"

class RSI_MainWnd
{
public:
  RSI_MainWnd();
  ~RSI_MainWnd();

  HWND Handle() const { return m_hwnd; }
  void ToggleLibrary();
  bool IsLibraryFull() const;

  static WDL_DLGRET MainWndProc(HWND hwnd, UINT msg, WPARAM wparam, LPARAM lparam);
private:
  int UpdateScreenRegions();
  void OnInitDialog();
  void OnSysCommand();
  int OnClose();
  void OnSize();
  void OnMove();
  void OnDestroy();
  void OnCommand();
  void OnTimer();
  void OnPaint();
  WDL_DLGRET MainWndLoop(UINT msg, WPARAM wparam, LPARAM lparam);

  HWND m_hwnd;
  UINT m_msg;
  WPARAM m_wparam;
  LPARAM m_lparam;
  int m_x, m_y, m_w, m_h;
  WDL_WndSizer m_resize;
  HMENU m_main_menu;
  WDL_VirtualWnd_Painter m_painter;
  bool m_library;
};

#endif // _RSI_MAIN_WND_H_
