// Copyright (c) 2021 Giorgos Vougioukas
//
// The license can be found in the LICENSE file.

#include "RSI/definitions.h"
#include "RSI/render_system.h"
#include "RSI/about_wnd.h"
#include "RSI/changelog_wnd.h"
#include "RSI/license_wnd.h"
#include "RSI/load_wnd.h"
#include "RSI/main_wnd.h"
#include "RSI/preferences_wnd.h"
#include "RSI/stats_wnd.h"
#include "RSI/library_wnd.h"

// VK_OEM_1: semicolon (0xBA)
// VK_OEM_2: slash (0xBF)
// VK_OEM_3: tilde (0xC0)
// VK_OEM_4: left bracket (0xDB)
// VK_OEM_5: backslash (0xDC)
// VK_OEM_6: right bracket (0xDD)
// VK_OEM_7: quote (0xDE)
// VK_OEM_PLUS: equal (0xBB)
// VK_OEM_MINUS: dash (0xBD)
// VK_OEM_COMMA: comma (0xBC)
// VK_OEM_PERIOD: period (0xBE)

int RSI_ProcessMessage(MSG *msg)
{
  if (g_mainwnd && (msg->hwnd == g_mainwnd->Handle() || IsChild(g_mainwnd->Handle(), msg->hwnd)))
  {
    if (msg->wParam == VK_CONTROL &&
        (msg->message == WM_KEYDOWN ||
          msg->message == WM_KEYUP))
    {
      if (GetCapture() == g_mainwnd->Handle())
      {
        //InvalidateRect(g_mainwnd->Handle(), NULL, FALSE);
      }
    }

    if (GetFocus() == GetDlgItem(g_librarywnd->Handle(), IDC_EDIT1))
    {
      if (msg->message == WM_KEYDOWN || msg->message == WM_SYSKEYDOWN /* || msg->message == WM_CHAR */)
      {
        if (msg->wParam == VK_ESCAPE)
        {
          if (!(GetAsyncKeyState(VK_CONTROL) & 0x8000) &&
            !(GetAsyncKeyState(VK_SHIFT) & 0x8000) &&
            !(GetAsyncKeyState(VK_MENU) & 0x8000))
          {
            if (!GetCapture())
            {
              g_librarywnd->ShowSearch(false);
            }

            return 1;
          }
        }
        if (msg->wParam == VK_RETURN)
        {
          if (!(GetAsyncKeyState(VK_CONTROL) & 0x8000) &&
            !(GetAsyncKeyState(VK_SHIFT) & 0x8000) &&
            !(GetAsyncKeyState(VK_MENU) & 0x8000))
          {
            if (!GetCapture())
            {
              g_librarywnd->Search();
            }

            return 1;
          }
        }
        if (msg->wParam == 'L')
        {
          if ((GetAsyncKeyState(VK_CONTROL) & 0x8000) &&
            !(GetAsyncKeyState(VK_SHIFT) & 0x8000) &&
            !(GetAsyncKeyState(VK_MENU) & 0x8000))
          {
            if (!GetCapture())
            {
              HWND edt = GetDlgItem(g_librarywnd->Handle(), IDC_EDIT1);
              SendMessage(edt, EM_SETSEL, 0, -1);
              SetFocus(edt);
            }

            return 1;
          }
        }
        if (msg->wParam == 'D')
        {
          if (!(GetAsyncKeyState(VK_CONTROL) & 0x8000) &&
            !(GetAsyncKeyState(VK_SHIFT) & 0x8000) &&
            (GetAsyncKeyState(VK_MENU) & 0x8000))
          {
            if (!GetCapture())
            {
              HWND edt = GetDlgItem(g_librarywnd->Handle(), IDC_EDIT1);
              SendMessage(edt, EM_SETSEL, 0, -1);
              SetFocus(edt);
            }

            return 1;
          }
        }
      }
      return 0;
    }

    //if (msg->message == WM_MOUSEWHEEL)
    //{
    //  SendMessage(msg->hwnd, WM_MOUSEWHEEL, msg->wParam, msg->lParam);

    //  return 1;
    //}

    if (msg->message == WM_KEYDOWN || msg->message == WM_SYSKEYDOWN /* || msg->message == WM_CHAR */)
    {
      if (msg->lParam & FVIRTKEY)
      {
        if (msg->wParam == VK_F1)
        {
          if ((GetAsyncKeyState(VK_CONTROL) & 0x8000) &&
            !(GetAsyncKeyState(VK_SHIFT) & 0x8000) &&
            !(GetAsyncKeyState(VK_MENU) & 0x8000))
          {
            if (!GetCapture())
            {
              SendMessage(g_mainwnd->Handle(), WM_COMMAND, ID_HELP_ABOUTRSI, 0);
            }

            return 1;
          }
        }
        if (msg->wParam == VK_F2)
        {
          if ((GetAsyncKeyState(VK_CONTROL) & 0x8000) &&
            !(GetAsyncKeyState(VK_SHIFT) & 0x8000) &&
            !(GetAsyncKeyState(VK_MENU) & 0x8000))
          {
            if (!GetCapture())
            {
              SendMessage(g_mainwnd->Handle(), WM_COMMAND, ID_HELP_CHANGELOG, 0);
            }

            return 1;
          }
        }
        if (msg->wParam == VK_F3)
        {
          if ((GetAsyncKeyState(VK_CONTROL) & 0x8000) &&
            !(GetAsyncKeyState(VK_SHIFT) & 0x8000) &&
            !(GetAsyncKeyState(VK_MENU) & 0x8000))
          {
            if (!GetCapture())
            {
              SendMessage(g_mainwnd->Handle(), WM_COMMAND, ID_HELP_VERSION, 0);
            }

            return 1;
          }
        }
        if (msg->wParam == VK_F1)
        {
          if (!(GetAsyncKeyState(VK_CONTROL) & 0x8000) &&
            !(GetAsyncKeyState(VK_SHIFT) & 0x8000) &&
            !(GetAsyncKeyState(VK_MENU) & 0x8000))
          {
            if (!GetCapture())
            {
              g_rendersystem->SetActiveTrack(1);
            }

            return 1;
          }
          if (!(GetAsyncKeyState(VK_CONTROL) & 0x8000) &&
            (GetAsyncKeyState(VK_SHIFT) & 0x8000) &&
            !(GetAsyncKeyState(VK_MENU) & 0x8000))
          {
            if (!GetCapture())
            {
              g_rendersystem->EjectTrack(1);
            }

            return 1;
          }
        }
        if (msg->wParam == VK_F2)
        {
          if (!(GetAsyncKeyState(VK_CONTROL) & 0x8000) &&
            !(GetAsyncKeyState(VK_SHIFT) & 0x8000) &&
            !(GetAsyncKeyState(VK_MENU) & 0x8000))
          {
            if (!GetCapture())
            {
              g_rendersystem->SetActiveTrack(2);
            }

            return 1;
          }
          if (!(GetAsyncKeyState(VK_CONTROL) & 0x8000) &&
            (GetAsyncKeyState(VK_SHIFT) & 0x8000) &&
            !(GetAsyncKeyState(VK_MENU) & 0x8000))
          {
            if (!GetCapture())
            {
              g_rendersystem->EjectTrack(2);
            }

            return 1;
          }
        }
        if (msg->wParam == VK_F3)
        {
          if (!(GetAsyncKeyState(VK_CONTROL) & 0x8000) &&
            !(GetAsyncKeyState(VK_SHIFT) & 0x8000) &&
            !(GetAsyncKeyState(VK_MENU) & 0x8000))
          {
            if (!GetCapture())
            {
              g_rendersystem->SetActiveTrack(3);
            }

            return 1;
          }
          if (!(GetAsyncKeyState(VK_CONTROL) & 0x8000) &&
            (GetAsyncKeyState(VK_SHIFT) & 0x8000) &&
            !(GetAsyncKeyState(VK_MENU) & 0x8000))
          {
            if (!GetCapture())
            {
              g_rendersystem->EjectTrack(3);
            }

            return 1;
          }
        }
        if (msg->wParam == VK_F4)
        {
          if (!(GetAsyncKeyState(VK_CONTROL) & 0x8000) &&
            !(GetAsyncKeyState(VK_SHIFT) & 0x8000) &&
            !(GetAsyncKeyState(VK_MENU) & 0x8000))
          {
            if (!GetCapture())
            {
              g_rendersystem->SetActiveTrack(4);
            }

            return 1;
          }
          if (!(GetAsyncKeyState(VK_CONTROL) & 0x8000) &&
            (GetAsyncKeyState(VK_SHIFT) & 0x8000) &&
            !(GetAsyncKeyState(VK_MENU) & 0x8000))
          {
            if (!GetCapture())
            {
              g_rendersystem->EjectTrack(4);
            }

            return 1;
          }
        }
        if (msg->wParam == VK_F5)
        {
          if (!(GetAsyncKeyState(VK_CONTROL) & 0x8000) &&
            !(GetAsyncKeyState(VK_SHIFT) & 0x8000) &&
            !(GetAsyncKeyState(VK_MENU) & 0x8000))
          {
            if (!GetCapture())
            {
              g_rendersystem->SetActiveTrack(5);
            }

            return 1;
          }
          if (!(GetAsyncKeyState(VK_CONTROL) & 0x8000) &&
            (GetAsyncKeyState(VK_SHIFT) & 0x8000) &&
            !(GetAsyncKeyState(VK_MENU) & 0x8000))
          {
            if (!GetCapture())
            {
              g_rendersystem->EjectTrack(5);
            }

            return 1;
          }
        }
        if (msg->wParam == VK_F6)
        {
          if (!(GetAsyncKeyState(VK_CONTROL) & 0x8000) &&
            !(GetAsyncKeyState(VK_SHIFT) & 0x8000) &&
            !(GetAsyncKeyState(VK_MENU) & 0x8000))
          {
            if (!GetCapture())
            {
              g_rendersystem->SetActiveTrack(6);
            }

            return 1;
          }
          if (!(GetAsyncKeyState(VK_CONTROL) & 0x8000) &&
            (GetAsyncKeyState(VK_SHIFT) & 0x8000) &&
            !(GetAsyncKeyState(VK_MENU) & 0x8000))
          {
            if (!GetCapture())
            {
              g_rendersystem->EjectTrack(6);
            }

            return 1;
          }
        }
        if (msg->wParam == VK_F7)
        {
          if (!(GetAsyncKeyState(VK_CONTROL) & 0x8000) &&
            !(GetAsyncKeyState(VK_SHIFT) & 0x8000) &&
            !(GetAsyncKeyState(VK_MENU) & 0x8000))
          {
            if (!GetCapture())
            {
              g_rendersystem->SetActiveTrack(7);
            }

            return 1;
          }
          if (!(GetAsyncKeyState(VK_CONTROL) & 0x8000) &&
            (GetAsyncKeyState(VK_SHIFT) & 0x8000) &&
            !(GetAsyncKeyState(VK_MENU) & 0x8000))
          {
            if (!GetCapture())
            {
              g_rendersystem->EjectTrack(7);
            }

            return 1;
          }
        }
        if (msg->wParam == VK_F8)
        {
          if (!(GetAsyncKeyState(VK_CONTROL) & 0x8000) &&
            !(GetAsyncKeyState(VK_SHIFT) & 0x8000) &&
            !(GetAsyncKeyState(VK_MENU) & 0x8000))
          {
            if (!GetCapture())
            {
              g_rendersystem->SetActiveTrack(8);
            }

            return 1;
          }
          if (!(GetAsyncKeyState(VK_CONTROL) & 0x8000) &&
            (GetAsyncKeyState(VK_SHIFT) & 0x8000) &&
            !(GetAsyncKeyState(VK_MENU) & 0x8000))
          {
            if (!GetCapture())
            {
              g_rendersystem->EjectTrack(8);
            }

            return 1;
          }
        }
        if (msg->wParam == VK_F9)
        {
          if (!(GetAsyncKeyState(VK_CONTROL) & 0x8000) &&
            !(GetAsyncKeyState(VK_SHIFT) & 0x8000) &&
            !(GetAsyncKeyState(VK_MENU) & 0x8000))
          {
            if (!GetCapture())
            {
              g_rendersystem->SetActiveTrack(9);
            }

            return 1;
          }
          if (!(GetAsyncKeyState(VK_CONTROL) & 0x8000) &&
            (GetAsyncKeyState(VK_SHIFT) & 0x8000) &&
            !(GetAsyncKeyState(VK_MENU) & 0x8000))
          {
            if (!GetCapture())
            {
              g_rendersystem->EjectTrack(9);
            }

            return 1;
          }
        }
        if (msg->wParam == VK_F10)
        {
          if (!(GetAsyncKeyState(VK_CONTROL) & 0x8000) &&
            !(GetAsyncKeyState(VK_SHIFT) & 0x8000) &&
            !(GetAsyncKeyState(VK_MENU) & 0x8000))
          {
            if (!GetCapture())
            {
              g_rendersystem->SetActiveTrack(10);
            }

            return 1;
          }
          if (!(GetAsyncKeyState(VK_CONTROL) & 0x8000) &&
            (GetAsyncKeyState(VK_SHIFT) & 0x8000) &&
            !(GetAsyncKeyState(VK_MENU) & 0x8000))
          {
            if (!GetCapture())
            {
              g_rendersystem->EjectTrack(10);
            }

            return 1;
          }
        }
        if (msg->wParam == VK_F11)
        {
          if (!(GetAsyncKeyState(VK_CONTROL) & 0x8000) &&
            !(GetAsyncKeyState(VK_SHIFT) & 0x8000) &&
            !(GetAsyncKeyState(VK_MENU) & 0x8000))
          {
            if (!GetCapture())
            {
              g_rendersystem->SetActiveTrack(11);
            }

            return 1;
          }
          if (!(GetAsyncKeyState(VK_CONTROL) & 0x8000) &&
            (GetAsyncKeyState(VK_SHIFT) & 0x8000) &&
            !(GetAsyncKeyState(VK_MENU) & 0x8000))
          {
            if (!GetCapture())
            {
              g_rendersystem->EjectTrack(11);
            }

            return 1;
          }
        }
        if (msg->wParam == VK_F12)
        {
          if (!(GetAsyncKeyState(VK_CONTROL) & 0x8000) &&
            !(GetAsyncKeyState(VK_SHIFT) & 0x8000) &&
            !(GetAsyncKeyState(VK_MENU) & 0x8000))
          {
            if (!GetCapture())
            {
              g_rendersystem->SetActiveTrack(12);
            }

            return 1;
          }
          if (!(GetAsyncKeyState(VK_CONTROL) & 0x8000) &&
            (GetAsyncKeyState(VK_SHIFT) & 0x8000) &&
            !(GetAsyncKeyState(VK_MENU) & 0x8000))
          {
            if (!GetCapture())
            {
              g_rendersystem->EjectTrack(12);
            }

            return 1;
          }
        }
      } // FVIRTKEY

      if (msg->wParam == 'A')
      {
        if ((GetAsyncKeyState(VK_CONTROL) & 0x8000) &&
          !(GetAsyncKeyState(VK_SHIFT) & 0x8000) &&
          !(GetAsyncKeyState(VK_MENU) & 0x8000))
        {
          if (!GetCapture())
          {
            SendMessage(g_mainwnd->Handle(), WM_COMMAND, ID_FILE_LOADTRACK, 0);
          }

          return 1;
        }
      }
      if (msg->wParam == 'Q')
      {
        if ((GetAsyncKeyState(VK_CONTROL) & 0x8000) &&
          !(GetAsyncKeyState(VK_SHIFT) & 0x8000) &&
          !(GetAsyncKeyState(VK_MENU) & 0x8000))
        {
          if (!GetCapture())
          {
            SendMessage(g_mainwnd->Handle(), WM_COMMAND, ID_FILE_EXIT, 0);
          }

          return 1;
        }
      }
      if (msg->wParam == 'P')
      {
        if ((GetAsyncKeyState(VK_CONTROL) & 0x8000) &&
          !(GetAsyncKeyState(VK_SHIFT) & 0x8000) &&
          !(GetAsyncKeyState(VK_MENU) & 0x8000))
        {
          if (!GetCapture())
          {
            SendMessage(g_mainwnd->Handle(), WM_COMMAND, ID_OPTIONS_PREFERENCES, 0);
          }

          return 1;
        }
      }
      if (msg->wParam == 'Q')
      {
        if (!(GetAsyncKeyState(VK_CONTROL) & 0x8000) &&
          !(GetAsyncKeyState(VK_SHIFT) & 0x8000) &&
          !(GetAsyncKeyState(VK_MENU) & 0x8000))
        {
          if (!GetCapture())
          {
            g_rendersystem->DecreaseShift();
          }

          return 1;
        }
        if (!(GetAsyncKeyState(VK_CONTROL) & 0x8000) &&
          (GetAsyncKeyState(VK_SHIFT) & 0x8000) &&
          !(GetAsyncKeyState(VK_MENU) & 0x8000))
        {
          if (!GetCapture())
          {
            g_rendersystem->DecreaseShift(true);
          }

          return 1;
        }
      }
      if (msg->wParam == 'W')
      {
        if (!(GetAsyncKeyState(VK_CONTROL) & 0x8000) &&
          !(GetAsyncKeyState(VK_SHIFT) & 0x8000) &&
          !(GetAsyncKeyState(VK_MENU) & 0x8000))
        {
          if (!GetCapture())
          {
            g_rendersystem->IncreaseShift();
          }

          return 1;
        }
        if (!(GetAsyncKeyState(VK_CONTROL) & 0x8000) &&
          (GetAsyncKeyState(VK_SHIFT) & 0x8000) &&
          !(GetAsyncKeyState(VK_MENU) & 0x8000))
        {
          if (!GetCapture())
          {
            g_rendersystem->IncreaseShift(true);
          }

          return 1;
        }
      }
      if (msg->wParam == 'E')
      {
        if (!(GetAsyncKeyState(VK_CONTROL) & 0x8000) &&
          !(GetAsyncKeyState(VK_SHIFT) & 0x8000) &&
          !(GetAsyncKeyState(VK_MENU) & 0x8000))
        {
          if (!GetCapture())
          {
            g_rendersystem->DecreaseTempo();
          }

          return 1;
        }
        if (!(GetAsyncKeyState(VK_CONTROL) & 0x8000) &&
          (GetAsyncKeyState(VK_SHIFT) & 0x8000) &&
          !(GetAsyncKeyState(VK_MENU) & 0x8000))
        {
          if (!GetCapture())
          {
            g_rendersystem->DecreaseTempo(true);
          }

          return 1;
        }
      }
      if (msg->wParam == 'R')
      {
        if (!(GetAsyncKeyState(VK_CONTROL) & 0x8000) &&
          !(GetAsyncKeyState(VK_SHIFT) & 0x8000) &&
          !(GetAsyncKeyState(VK_MENU) & 0x8000))
        {
          if (!GetCapture())
          {
            g_rendersystem->IncreaseTempo();
          }

          return 1;
        }
        if (!(GetAsyncKeyState(VK_CONTROL) & 0x8000) &&
          (GetAsyncKeyState(VK_SHIFT) & 0x8000) &&
          !(GetAsyncKeyState(VK_MENU) & 0x8000))
        {
          if (!GetCapture())
          {
            g_rendersystem->IncreaseTempo(true);
          }

          return 1;
        }
        if ((GetAsyncKeyState(VK_CONTROL) & 0x8000) &&
          !(GetAsyncKeyState(VK_SHIFT) & 0x8000) &&
          !(GetAsyncKeyState(VK_MENU) & 0x8000))
        {
          if (!GetCapture())
          {
            g_rendersystem->ToggleRepeat();
          }

          return 1;
        }
      }
      if (msg->wParam == 'T')
      {
        if (!(GetAsyncKeyState(VK_CONTROL) & 0x8000) &&
          !(GetAsyncKeyState(VK_SHIFT) & 0x8000) &&
          !(GetAsyncKeyState(VK_MENU) & 0x8000))
        {
          if (!GetCapture())
          {
            g_rendersystem->ResetShiftTempo();
          }

          return 1;
        }
      }
      if (msg->wParam == 'D')
      {
        if (!(GetAsyncKeyState(VK_CONTROL) & 0x8000) &&
          !(GetAsyncKeyState(VK_SHIFT) & 0x8000) &&
          !(GetAsyncKeyState(VK_MENU) & 0x8000))
        {
          if (!GetCapture())
          {
            g_rendersystem->DecreaseVolume();
          }

          return 1;
        }
        if ((GetAsyncKeyState(VK_CONTROL) & 0x8000) &&
          !(GetAsyncKeyState(VK_SHIFT) & 0x8000) &&
          !(GetAsyncKeyState(VK_MENU) & 0x8000))
        {
          if (!GetCapture())
          {
            g_rendersystem->SetVolume(-150.0);
          }

          return 1;
        }
      }
      if (msg->wParam == 'F')
      {
        if (!(GetAsyncKeyState(VK_CONTROL) & 0x8000) &&
          !(GetAsyncKeyState(VK_SHIFT) & 0x8000) &&
          !(GetAsyncKeyState(VK_MENU) & 0x8000))
        {
          if (!GetCapture())
          {
            g_rendersystem->IncreaseVolume();
          }

          return 1;
        }
        if ((GetAsyncKeyState(VK_CONTROL) & 0x8000) &&
          !(GetAsyncKeyState(VK_SHIFT) & 0x8000) &&
          !(GetAsyncKeyState(VK_MENU) & 0x8000))
        {
          if (!GetCapture())
          {
            g_rendersystem->SetVolume(0.0);
          }

          return 1;
        }
      }
      if (msg->wParam == 'S')
      {
        if (!(GetAsyncKeyState(VK_CONTROL) & 0x8000) &&
          !(GetAsyncKeyState(VK_SHIFT) & 0x8000) &&
          !(GetAsyncKeyState(VK_MENU) & 0x8000))
        {
          if (!GetCapture())
          {
            g_rendersystem->StartStop(true);
          }

          return 1;
        }
      }
      if (msg->wParam == 'Z')
      {
        if (!(GetAsyncKeyState(VK_CONTROL) & 0x8000) &&
          !(GetAsyncKeyState(VK_SHIFT) & 0x8000) &&
          !(GetAsyncKeyState(VK_MENU) & 0x8000))
        {
          if (!GetCapture())
          {
            g_rendersystem->Pause();
          }

          return 1;
        }
      }
      if (msg->wParam == 'X')
      {
        if (!(GetAsyncKeyState(VK_CONTROL) & 0x8000) &&
          !(GetAsyncKeyState(VK_SHIFT) & 0x8000) &&
          !(GetAsyncKeyState(VK_MENU) & 0x8000))
        {
          if (!GetCapture())
          {
            g_rendersystem->FastForward(false);
            g_rendersystem->Rewind(true);
          }

          return 1;
        }
      }
      if (msg->wParam == 'C')
      {
        if (!(GetAsyncKeyState(VK_CONTROL) & 0x8000) &&
          !(GetAsyncKeyState(VK_SHIFT) & 0x8000) &&
          !(GetAsyncKeyState(VK_MENU) & 0x8000))
        {
          if (!GetCapture())
          {
            g_rendersystem->Rewind(false);
            g_rendersystem->FastForward(true);
          }

          return 1;
        }
      }
      if (msg->wParam == 'V')
      {
        if (!(GetAsyncKeyState(VK_CONTROL) & 0x8000) &&
          !(GetAsyncKeyState(VK_SHIFT) & 0x8000) &&
          !(GetAsyncKeyState(VK_MENU) & 0x8000))
        {
          if (!GetCapture())
          {
            g_rendersystem->Play();
          }

          return 1;
        }
        if ((GetAsyncKeyState(VK_CONTROL) & 0x8000) &&
          !(GetAsyncKeyState(VK_SHIFT) & 0x8000) &&
          !(GetAsyncKeyState(VK_MENU) & 0x8000))
        {
          if (!GetCapture())
          {
            g_rendersystem->ToggleReversePlayback();
          }

          return 1;
        }
        if ((GetAsyncKeyState(VK_CONTROL) & 0x8000) &&
          (GetAsyncKeyState(VK_SHIFT) & 0x8000) &&
          !(GetAsyncKeyState(VK_MENU) & 0x8000))
        {
          if (!GetCapture())
          {
            g_rendersystem->PlayReverse();
          }

          return 1;
        }
      }
      if (msg->wParam == 'B')
      {
        if (!(GetAsyncKeyState(VK_CONTROL) & 0x8000) &&
          !(GetAsyncKeyState(VK_SHIFT) & 0x8000) &&
          !(GetAsyncKeyState(VK_MENU) & 0x8000))
        {
          if (!GetCapture())
          {
            g_rendersystem->Stop();
          }

          return 1;
        }
      }
      if (msg->wParam == 'G')
      {
        if ((GetAsyncKeyState(VK_CONTROL) & 0x8000) &&
          !(GetAsyncKeyState(VK_SHIFT) & 0x8000) &&
          !(GetAsyncKeyState(VK_MENU) & 0x8000))
        {
          if (!GetCapture())
          {
            SendMessage(g_mainwnd->Handle(), WM_COMMAND, ID_OPTIONS_STATS, 0);
          }

          return 1;
        }
      }
      if (msg->wParam == VK_SPACE)
      {
        if (!(GetAsyncKeyState(VK_CONTROL) & 0x8000) &&
          !(GetAsyncKeyState(VK_SHIFT) & 0x8000) &&
          !(GetAsyncKeyState(VK_MENU) & 0x8000))
        {
          if (!GetCapture())
          {
            g_mainwnd->ToggleLibrary();
          }

          return 1;
        }
      }
      if (msg->wParam == VK_RETURN)
      {
        if (!(GetAsyncKeyState(VK_CONTROL) & 0x8000) &&
          !(GetAsyncKeyState(VK_SHIFT) & 0x8000) &&
          !(GetAsyncKeyState(VK_MENU) & 0x8000))
        {
          if (!GetCapture())
          {
            g_librarywnd->LoadFileTrack();
          }

          return 1;
        }
      }
      if (msg->wParam == 'L')
      {
        if ((GetAsyncKeyState(VK_CONTROL) & 0x8000) &&
          !(GetAsyncKeyState(VK_SHIFT) & 0x8000) &&
          !(GetAsyncKeyState(VK_MENU) & 0x8000))
        {
          if (!GetCapture())
          {
            g_librarywnd->ShowSearch(true);
            HWND edt = GetDlgItem(g_librarywnd->Handle(), IDC_EDIT1);
            SendMessage(edt, EM_SETSEL, 0, -1);
            SetFocus(edt);
          }

          return 1;
        }
      }
      if (msg->wParam == 'D')
      {
        if (!(GetAsyncKeyState(VK_CONTROL) & 0x8000) &&
          !(GetAsyncKeyState(VK_SHIFT) & 0x8000) &&
          (GetAsyncKeyState(VK_MENU) & 0x8000))
        {
          if (!GetCapture())
          {
            g_librarywnd->ShowSearch(true);
            HWND edt = GetDlgItem(g_librarywnd->Handle(), IDC_EDIT1);
            SendMessage(edt, EM_SETSEL, 0, -1);
            SetFocus(edt);
          }

          return 1;
        }
      }
      if (msg->wParam == VK_ESCAPE)
      {
        if (!(GetAsyncKeyState(VK_CONTROL) & 0x8000) &&
          !(GetAsyncKeyState(VK_SHIFT) & 0x8000) &&
          !(GetAsyncKeyState(VK_MENU) & 0x8000))
        {
          if (!GetCapture())
          {
            g_librarywnd->ShowSearch(false);
          }

          return 1;
        }
      }
#if _WIN32
      if (msg->wParam == VK_OEM_2)
#else
      if (msg->wParam == '/')
#endif
      {
        if (!(GetAsyncKeyState(VK_CONTROL) & 0x8000) &&
          !(GetAsyncKeyState(VK_SHIFT) & 0x8000) &&
          !(GetAsyncKeyState(VK_MENU) & 0x8000))
        {
          if (!GetCapture())
          {
            g_rendersystem->ToggleHeadphone();
          }

          return 1;
        }
      }
    }


    if (msg->message == WM_KEYUP || msg->message == WM_SYSKEYUP /* || msg->message == WM_CHAR */)
    {
      if (msg->wParam == 'S')
      {
        if (!(GetAsyncKeyState(VK_CONTROL) & 0x8000) &&
          !(GetAsyncKeyState(VK_SHIFT) & 0x8000) &&
          !(GetAsyncKeyState(VK_MENU) & 0x8000))
        {
          if (!GetCapture())
          {
            g_rendersystem->StartStop(false);
          }

          return 1;
        }
      }
      if (msg->wParam == 'X')
      {
        if (!(GetAsyncKeyState(VK_CONTROL) & 0x8000) &&
          !(GetAsyncKeyState(VK_SHIFT) & 0x8000) &&
          !(GetAsyncKeyState(VK_MENU) & 0x8000))
        {
          if (!GetCapture())
          {
            g_rendersystem->Rewind(false);
          }

          return 1;
        }
      }
      if (msg->wParam == 'C')
      {
        if (!(GetAsyncKeyState(VK_CONTROL) & 0x8000) &&
          !(GetAsyncKeyState(VK_SHIFT) & 0x8000) &&
          !(GetAsyncKeyState(VK_MENU) & 0x8000))
        {
          if (!GetCapture())
          {
            g_rendersystem->FastForward(false);
          }

          return 1;
        }
      }
    }
  }

  return 0;
}

void RSI_RunMessageLoop()
{
#if defined(_WIN32)
  for (;;) // Justin Frankel in the loop
  {
    MSG msg = { 0, };
    int vvv = GetMessage(&msg, NULL, 0, 0);

    if (!vvv)
    {
      break;
    }

    if (vvv < 0)
    {
      Sleep(10);
      continue;
    }

    if (!msg.hwnd)
    {
      DispatchMessage(&msg);
      continue;
    }

    vvv = RSI_ProcessMessage(&msg);

    if (vvv > 0)
    {
      continue;
    }

    if (g_mainwnd->Handle())
    {
      if (IsDialogMessage(g_mainwnd->Handle(), &msg))
      {
        continue;
      }
    }

    if (g_changelogwnd)
    {
      if (IsDialogMessage(g_changelogwnd->Handle(), &msg))
      {
        continue;
      }
    }

    if (g_prefwnd)
    {
      if (IsDialogMessage(g_prefwnd->Handle(), &msg))
      {
        continue;
      }
    }

    if (g_licwnd)
    {
      if (IsDialogMessage(g_licwnd->Handle(), &msg))
      {
        continue;
      }
    }

    if (g_aboutwnd)
    {
      if (IsDialogMessage(g_aboutwnd->Handle(), &msg))
      {
        continue;
      }
    }

    if (IsDialogMessage(g_loadwnd, &msg))
    {
      continue;
    }

    if (g_statswnd)
    {
      if (IsDialogMessage(g_statswnd->Handle(), &msg))
      {
        continue;
      }
    }

    if (g_librarywnd)
    {
      if (IsDialogMessage(g_librarywnd->Handle(), &msg))
      {
        continue;
      }
    }

    HWND parent = NULL;
    HWND temp = msg.hwnd;

    do
    {
      if (GetClassLong(temp, GCW_ATOM) == (INT)32770)
      {
        parent = temp;

        if (!(GetWindowLong(temp, GWL_STYLE) &WS_CHILD))
        {
          break;  // not a child, exit
        }
      }
    }
    while (temp = GetParent(temp));

    if (parent && IsDialogMessage(parent, &msg))
    {
      continue;
    }

    TranslateMessage(&msg);
    DispatchMessage(&msg);
  }
#else
  for (;;)
  {
    MSG msg = { 0, };
    int x = RSI_ProcessMessage(&msg);

    if (x == 0)
    {
      break;
    }
  }
#endif
}
