// Copyright (c) 2021 Giorgos Vougioukas
//
// The license can be found in the LICENSE file.

#ifndef _RSI_MODULE_CREATION_H_
#define _RSI_MODULE_CREATION_H_

#include "RSI/definitions.h"
#include "RSI/rsi_plugin.h"

RSI_IFileInput *CreateFileInput(const char *filename);
RSI_IFileTag *CreateFileTag(const char *filename);
RSI_IFilePic *CreateFilePic(const char *filename);
RSI_IAudioStreamer *CreateAudioStreamer();
RSI_IAudioStreamerDevice *CreateAudioStreamerDevice(const char *name);
RSI_IPitchShift *CreatePitchShift(const char *name);
RSI_IFXProcessor *CreateFXProcessor();

void LoadPlugins();
void ReleasePlugins();

#endif // _RSI_MODULE_CREATION_H_
