// Copyright (c) 2022 Giorgos Vougioukas
//
// The license can be found in the LICENSE file.

#ifndef _RSI_PREFERENCES_WND_H_
#define _RSI_PREFERENCES_WND_H_

#include "RSI/definitions.h"
#include "RSI/preferences.h"
#include "RSI/editor.h"
#include "RSI/app_info.h"

#include "WDL/wingui/wndsize.h"
#include "WDL/wingui/virtwnd.h"

class RSI_PreferencesWnd
{
public:
  RSI_PreferencesWnd();
  ~RSI_PreferencesWnd();

  HWND Handle() const { return m_hwnd; }
  static WDL_DLGRET PreferencesWndProc(HWND hwnd, UINT msg, WPARAM wparam, LPARAM lparam);
private:
  void OnInitDialog();
  void OnTimer();
  void OnDestroy();
  void OnSize();
  void OnCommand();
  void OnSysCommand();
  void OnToggleFocus();
  void OnPaint();
  WDL_DLGRET PreferencesWndLoop(UINT msg, WPARAM wparam, LPARAM lparam);

  HWND m_hwnd;
  UINT m_msg;
  WPARAM m_wparam;
  LPARAM m_lparam;
  WDL_WndSizer m_resize;
  WDL_VWnd_Painter m_painter;
  RSI_PreviewEditor m_preview;
  RSI_PreferencesEditor m_editor;
};

#endif // _RSI_PREFERENCES_WND_H_
