// Copyright (c) 2022 Giorgos Vougioukas
//
// The license can be found in the LICENSE file.

#include "RSI/skin.h"

RSI_Skin::RSI_Skin()
  : m_loaded(false)
  , icon_button_bitmap(NULL)
{}

RSI_Skin::~RSI_Skin()
{
  UnloadSkin();
}

void RSI_Skin::LoadSkin()
{
  WDL_HeapBuf data;
  WDL_FileRead *fr;
  WDL_FastString path(g_modpath.Get());
  path.Append("skin" WDL_DIRCHAR_STR "mask" WDL_DIRCHAR_STR "button.png");
  fr = new WDL_FileRead(path.Get());
  if (fr->IsOpen())
  {
    data.Resize((int)fr->GetSize());
    fr->Read(data.Get(), data.GetSize());
  }
  icon_button_bitmap = LICE_LoadPNGFromMemory(data.Get(), data.GetSize());
  icon_button_skin_config.image = icon_button_bitmap;
  icon_button_skin_config.image_issingle = false;
  //icon_button_skin_config.image_ltrb_main[0] = 0;
  //icon_button_skin_config.image_ltrb_main[1] = 0;
  //icon_button_skin_config.image_ltrb_main[2] = 20;
  //icon_button_skin_config.image_ltrb_main[3] = 20;
  //icon_button_skin_config.image_ltrb_ol[0] = 20;
  //icon_button_skin_config.image_ltrb_ol[1] = 0;
  //icon_button_skin_config.image_ltrb_ol[2] = 40;
  //icon_button_skin_config.image_ltrb_ol[3] = 20;
  WDL_VirtualIconButton_PreprocessSkinConfig(&icon_button_skin_config);
  delete fr;

  //path.Set(g_modpath.Get());
  //path.Append("skin" WDL_DIRCHAR_STR "mask" WDL_DIRCHAR_STR "trackwndbg.png");
  //fr = new WDL_FileRead(path.Get());
  //if (fr->IsOpen())
  //{
  //  data.Resize((int)fr->GetSize());
  //  fr->Read(data.Get(), data.GetSize());
  //}
  //trackwnd_bg_bitmap = LICE_LoadPNGFromMemory(data.Get(), data.GetSize());
  //trackwnd_bg_config.bgimage = trackwnd_bg_bitmap;
  //WDL_VirtualWnd_PreprocessBGConfig(&trackwnd_bg_config);
  //delete fr;

  m_loaded = true;
}

void RSI_Skin::UnloadSkin()
{
  if (icon_button_bitmap) { delete icon_button_bitmap; icon_button_bitmap = NULL; }
  if (trackwnd_bg_bitmap) { delete trackwnd_bg_bitmap; trackwnd_bg_bitmap = NULL; }
}
