// Copyright (c) 2022 Giorgos Vougioukas
//
// The license can be found in the LICENSE file.

#ifndef _RSI_WAVEFORM_WND_H_
#define _RSI_WAVEFORM_WND_H_

#include "RSI/definitions.h"
#include "RSI/preferences.h"
#include "RSI/render_system.h"
#include "RSI/data_bank.h"
#include "RSI/app_info.h"
#include "RSI/plugin.h"

#include "WDL/wingui/wndsize.h"
#include "WDL/wdlstring.h"
#include "WDL/lice/lice.h"
#include "WDL/lice/lice_text.h"
#include "WDL/wingui/virtwnd.h"

class RSI_WaveformAWnd
{
public:
  RSI_WaveformAWnd(HWND hwnd)
    : m_hwnd(hwnd)
    , m_bm(NULL)
    , m_font(NULL)
    , m_trkidx(0)
    , m_sltidx(0)
  {
    m_bgc = g_preferences->GetBackgroundColor();
    m_txtc = g_preferences->GetTextColor();
  }

  ~RSI_WaveformAWnd()
  {
    if (m_font) delete m_font;
  }

  static WDL_DLGRET WaveformAWndProc(HWND hwnd, UINT msg, WPARAM wparam, LPARAM lparam);
private:
  void OnCreate();
  void OnDestroy();
  void OnPaint();
  void OnLButtonDown();
  void OnLButtonUp();
  void OnMouseMove();
  void OnSize();
  void OnTimer();
  WDL_DLGRET WaveformAWndLoop(UINT msg, WPARAM wparam, LPARAM lparam);

  HWND m_hwnd;
  UINT m_msg;
  WPARAM m_wparam;
  LPARAM m_lparam;
  WDL_VirtualWnd_Painter m_painter;
  LICE_IBitmap *m_bm;
  LICE_IFont *m_font;
  int m_bgc, m_txtc;
  int m_trkidx;
  int m_sltidx;
};

class RSI_WaveformBWnd
{
public:
  RSI_WaveformBWnd(HWND hwnd)
    : m_hwnd(hwnd)
    , m_bm(NULL)
    , m_font(NULL)
    , m_trkidx(0)
    , m_sltidx(0)
    , m_seekpos(-1)
    , m_seektime(0.0)
  {
    m_bgc = g_preferences->GetBackgroundColor();
    m_txtc = g_preferences->GetTextColor();
  }

  ~RSI_WaveformBWnd()
  {
    if (m_font) delete m_font;
  }

  static WDL_DLGRET WaveformBWndProc(HWND hwnd, UINT msg, WPARAM wparam, LPARAM lparam);
private:
  void OnCreate();
  void OnDestroy();
  void OnPaint();
  void OnLButtonDown();
  void OnLButtonUp();
  void OnMouseMove();
  void OnSize();
  void OnTimer();
  WDL_DLGRET WaveformBWndLoop(UINT msg, WPARAM wparam, LPARAM lparam);

  HWND m_hwnd;
  UINT m_msg;
  WPARAM m_wparam;
  LPARAM m_lparam;
  WDL_VirtualWnd_Painter m_painter;
  LICE_IBitmap *m_bm;
  LICE_IFont *m_font;
  int m_bgc, m_txtc;
  int m_trkidx;
  int m_sltidx;
  int m_seekpos;
  double m_seektime;
  WDL_FastString m_strbuf;
};

#endif // _RSI_WAVEFORM_WND_H_
