// Copyright (c) 2019 Giorgos Vougioukas
//
// The license can be found in the LICENSE file.

#ifndef _RSI_AUDIO_STREAMER_DIRECTSOUND_H_
#define _RSI_AUDIO_STREAMER_DIRECTSOUND_H_

#include <windows.h>

#include <portaudio.h>
#include <pa_win_ds.h>
#include <pa_util.h>

#include "RSI/rsi_plugin.h"

#include "WDL/heapbuf.h"
#include "WDL/queue.h"
#include "WDL/wdlstring.h"

class RSI_DirectSound : public RSI_IAudioStreamer
{
public:
  RSI_DirectSound();
  ~RSI_DirectSound();

  bool Open();
  void Start(RSI_AudioCallback callback);
  void Stop();
  void Close();
  bool IsRunning() const;
  double GetSampleRate() const;

private:
  static int pa_callback(const void *input, void *output, unsigned long frame_count,
    const PaStreamCallbackTimeInfo *time_info, PaStreamCallbackFlags status_flags,
    void *user_data);

  PaError m_error;
  PaStream *m_stream;
  bool m_running;

  RSI_AudioCallback m_callback;

  int m_sample_fmt;
  int m_samplerate;
  int m_output_nch;
  int m_output_dev;

  WDL_TypedBuf<SAM> m_buffer;
  WDL_HeapBuf m_pcm;
};

#endif // _RSI_AUDIO_STREAMER_DIRECTSOUND_H_
