#ifndef _RSI_FLAC_TAG_H_
#define _RSI_FLAC_TAG_H_

#include "RSI/rsi_plugin_public.h"

extern "C"
{
  #include <FLAC/all.h>
  #include <share/win_utf8_io.h>
  #include <share/windows_unicode_filenames.h>
}

#include "WDL/wdlstring.h"
#include "WDL/fileread.h"
#include "WDL/assocarray.h"

class RSI_FlacTag : public RSI_IFileTag
{
public:
  RSI_FlacTag();
  ~RSI_FlacTag();

  bool Open(const char *filename);

  const char *GetType() const;

  const char *GetTitle() const;
  const char *GetArtist() const;
  const char *GetAlbum() const;
  const char *GetGenre() const;
  const char *GetTrack() const;
  const char *GetYear() const;
  const char *GetComment() const;

  WDL_INT64 GetFileSize() const;
  const char *GetFileName() const;
  const char *GetFilePath() const;
  const char *GetFileExtension() const;

private:
  WDL_FastString m_fn;
  WDL_FileRead *m_file;
  WDL_StringKeyedArray<char *> m_metadata;
};

#endif // _RSI_FLAC_TAG_H_
