#if defined(_WIN32) && defined(_DEBUG)
#include <vld.h>
#endif

//#define ENABLE_RSI_MP3_CONSOLE

#include "RSI/rsi_plugin_public.h"
#include "rsi_mp3/mp3_input.h"
#include "rsi_mp3/mp3_tag.h"

#include "WDL/wdlcstring.h"

double (*RSI_GetAudioDeviceSamplerate)();
void (*RSI_GetDiskReadMode)(int *rmode, int *rbufsize, int *rnbufs);
void (*RSI_GetResampleMode)(bool *interp, int *filtercnt,
  bool *sinc, int *sinc_size, int *sinc_interpsize);

static HINSTANCE flac_instance;
static HWND flac_main_hwnd;

RSI_IFileInput *CreateFromType(const char *type)
{
  if (!strcmp(type, "MP3"))
  {
    return new RSI_Mp3Input;
  }

  return NULL;
}

RSI_IFileInput *CreateFromFile(const char *filename)
{
  if (!wdl_filename_cmp(WDL_get_fileext(filename), ".mp3"))
  {
    RSI_Mp3Input *p = new RSI_Mp3Input;

    if (p->Open(filename))
    {
      return p;
    }

    delete p;
  }

  return NULL;
}

struct RSI_FileInputRegister mp3_reg_struct =
{
  CreateFromType,
  CreateFromFile,
};

RSI_IFileTag *CreateMp3Tag(const char *filename)
{
  if (!wdl_filename_cmp(WDL_get_fileext(filename), ".mp3"))
  {
    RSI_Mp3Tag *p = new RSI_Mp3Tag;

    if (p && p->Open(filename))
    {
      return p;
    }
    else
    {
      delete p;
    }
  }

  return NULL;
}

RSI_FileTagRegister mp3_tag_reg =
{
  &CreateMp3Tag
};

extern "C"
{
  RSI_PLUGIN_EXPORT int RSI_PLUGIN_ENTRYPOINT(
    RSI_PLUGIN_HINSTANCE instance, RSI_PluginInfo *rec)
  {
#if defined(_WIN32) && defined(_DEBUG) && defined(ENABLE_RSI_MP3_CONSOLE)
    // The first will use the console only if
    // the application is started by the command 
    // line. The second one will always enable
    // the console.
    //if (AttachConsole(ATTACH_PARENT_PROCESS))
    if (AttachConsole(ATTACH_PARENT_PROCESS) || AllocConsole())
    {
        freopen("CONOUT$", "w", stdout);
        freopen("CONOUT$", "w", stderr);
    }
#endif

    flac_instance = instance;

    if (rec)
    {
      if (rec->caller_version != RSI_PLUGIN_VERSION || !rec->GetFunc)
      {
        return 0;
      }

      flac_main_hwnd = rec->hwnd_main;

      *((void **)&RSI_GetAudioDeviceSamplerate) = rec->GetFunc("RSI_GetAudioDeviceSamplerate");
      *((void **)&RSI_GetDiskReadMode) = rec->GetFunc("RSI_GetDiskReadMode");
      *((void **)&RSI_GetResampleMode) = rec->GetFunc("RSI_GetResampleMode");

      if (!rec->Register || !RSI_GetAudioDeviceSamplerate || !RSI_GetDiskReadMode ||
        !RSI_GetResampleMode)
      {
        return 0;
      }

      rec->Register("input", &mp3_reg_struct);
      rec->Register("tag", &mp3_tag_reg);

      return 1;
    }
    else
    {
      return 0;
    }
  }
}
