#ifndef _RSI_MP3_TAG_H_
#define _RSI_MP3_TAG_H_

#include "RSI/rsi_plugin_public.h"

#include "WDL/wdlstring.h"
#include "WDL/fileread.h"
#include "WDL/assocarray.h"

class RSI_Mp3Tag : public RSI_IFileTag
{
public:
  RSI_Mp3Tag();
  ~RSI_Mp3Tag();

  bool Open(const char *filename);

  const char *GetType() const;

  const char *GetTitle() const;
  const char *GetArtist() const;
  const char *GetAlbum() const;
  const char *GetGenre() const;
  const char *GetTrack() const;
  const char *GetYear() const;
  const char *GetComment() const;

  WDL_INT64 GetFileSize() const;
  const char *GetFileName() const;
  const char *GetFilePath() const;
  const char *GetFileExtension() const;

private:
  WDL_FastString m_fn;
  WDL_FileRead *m_file;
  WDL_StringKeyedArray<char *> m_metadata;
};

#endif // _RSI_MP3_TAG_H_
