// Copyright (c) 2022 Giorgos Vougioukas
//
// The license can be found in the LICENSE file.

#ifndef _RSI_CHANGELOG_WND_H_
#define _RSI_CHANGELOG_WND_H_

#include "RSI/definitions.h"
#include "RSI/editor.h"
#include "RSI/app_info.h"

#include "WDL/wingui/wndsize.h"

class RSI_ChangelogWnd
{
public:
  RSI_ChangelogWnd();
  ~RSI_ChangelogWnd();

  HWND Handle() const { return m_hwnd; }
  static WDL_DLGRET ChangelogWndProc(HWND hwnd, UINT msg, WPARAM wparam, LPARAM lparam);
private:
  void OnInitDialog();
  void OnTimer();
  void OnDestroy();
  void OnSize();
  void OnCommand();
  void OnSysCommand();
  WDL_DLGRET ChangelogWndLoop(UINT msg, WPARAM wparam, LPARAM lparam);

  HWND m_hwnd;
  UINT m_msg;
  WPARAM m_wparam;
  LPARAM m_lparam;
  WDL_WndSizer m_resize;
  RSI_PreviewEditor m_preview;
};

#endif // _RSI_CHANGELOG_WND_H_
