// Copyright (c) 2019 Giorgos Vougioukas
//
// The license can be found in the LICENSE file.

#ifndef _RSI_DATABASE_H_
#define _RSI_DATABASE_H_

#include "RSI/definitions.h"
#include "third_party/sqlite/sqlite3.h"

#include "WDL/lineparse.h"
#include "WDL/wdlstring.h"
#include "WDL/ptrlist.h"
#include "WDL/mutex.h"
#include "WDL/fileread.h"

class RSI_Database
{
public:
  RSI_Database();
  ~RSI_Database();

  bool Open();
  bool IsOpen() const;
  void Close();

  void ScanFiles();
  void StopScan();

  bool IsScanInProgress() const;
  const char *GetProgressStage() const;
  const char *GetProgressFilename() const;
private:
  void ReadMetadata(const char *path);
  int Run();
  static unsigned WINAPI ThreadFunc(void *arg);

  HANDLE m_thread;
  bool m_killthread;
  WDL_Mutex m_mutex;
  int m_action;

  bool m_scaninprogress;
  WDL_FastString m_progressstage;

  LineParser m_lp;

  WDL_PtrList_DeleteOnDestroy<WDL_FastString> *m_paths;
  WDL_FastString m_sqlstr;

  bool m_cancel;
  bool m_open;

  WDL_FastString m_fn;
  WDL_FastString m_progfn;

  sqlite3 *m_db;
  sqlite3_stmt *m_stmt;
};

#endif // _RSI_DATABASE_H_
