// Copyright (c) 2022 Giorgos Vougioukas
//
// The license can be found in the LICENSE file.

#ifndef _RSI_STATS_H_
#define _RSI_STATS_H_

#include "RSI/definitions.h"

#if defined(_WIN32)

#include <psapi.h>

#elif defined(__linux__)

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <sys/types.h>
#include <sys/sysinfo.h>
#include <sys/times.h>
#include <sys/vtimes.h>

#elif defined(__APPLE__)

#endif

class RSI_Stats
{
public:
  RSI_Stats();
  ~RSI_Stats();

  WDL_UINT64 GetTotalPhysicalMem();
  WDL_UINT64 GetPhysicalMemUsed();
  WDL_UINT64 GetProcessMemUsed();
  double GetProcessCPUUsed();

#if defined(_WIN32)

private:
  void InitProcessCPUStats();
  void InitMemStats();

  // InitProcessCPUStats
  ULARGE_INTEGER m_lastcpu, m_lastsyscpu, m_lastusercpu;
  int m_numprocessors;
  HANDLE m_self;

  // GetProcessCPUUsed
  FILETIME m_ftime, m_fsys, m_fuser;
  ULARGE_INTEGER m_now, m_sys, m_user;
  double m_percent;

  // GetPhysicalMemUsed and GetTotalPhysicalMem
  MEMORYSTATUSEX m_meminfo;

  // GetProcessMemUsed
  PROCESS_MEMORY_COUNTERS_EX m_pmc;

#elif defined(__linux__)

private:
  void Init();
  int ParseLine(char* line);

  struct sysinfo m_meminfo;

  clock_t m_lastcpu, m_lastsyscpu, m_lastusercpu;
  int m_numprocessors;

#elif defined(__APPLE__)

private:

#endif

};

#endif // _RSI_STATS_H_
